/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.spring.config;

import org.adorsys.cryptoutils.exceptions.BaseException;
import org.adorsys.cryptoutils.storeconnectionfactory.ExtendedStoreConnectionFactory;
import org.adorsys.docusafe.spring.config.SpringDocusafeStoreconnectionProperties;
import org.adorsys.encobject.service.api.ExtendedStoreConnection;
import org.adorsys.encobject.types.properties.ConnectionProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(basePackages={"org.adorsys.docusafe.spring.config"})
public class UseExtendedStoreConnectionConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(UseExtendedStoreConnectionConfiguration.class);

    @Bean
    public ExtendedStoreConnection extendedStoreConnection(SpringDocusafeStoreconnectionProperties properties) {
        if (properties.getFilesystem() != null) {
            LOGGER.debug("jetzt filesystem");
            return ExtendedStoreConnectionFactory.get((ConnectionProperties)properties.getFilesystem());
        }
        if (properties.getAmazons3() != null) {
            LOGGER.debug("jetzt amazon");
            return ExtendedStoreConnectionFactory.get((ConnectionProperties)properties.getAmazons3());
        }
        if (properties.getMinio() != null) {
            LOGGER.debug("jetzt minio");
            return ExtendedStoreConnectionFactory.get((ConnectionProperties)properties.getMinio());
        }
        if (properties.getMongo() != null) {
            LOGGER.debug("jetzt mongo");
            return ExtendedStoreConnectionFactory.get((ConnectionProperties)properties.getMongo());
        }
        String emessage = "at least filesystem, amazons3, minio or mongo has to be specified with ";
        String message = emessage + "\ndocusafe:\n  storeconnection:\n    filesystem:\n      basedir: (mandatory)\n      encryptionpassword: (optional. null means no ecryption)\n" + "\ndocusafe:\n  storeconnection:\n    amazons3\n      url: (mandatory)\n      accesskey: (mandatory)\n      secretkey: (mandatory)\n      region: (optional)\n      rootbucket: (optional)\n      encryptionpassword: (optional. null means no ecryption)\n" + "\ndocusafe:\n  storeconnection:\n    minio:\n      url: (mandatory)\n      accesskey: (mandatory)\n      secretkey: (mandatory)\n      rootbucket: (optional)\n      encryptionpassword: (optional. null means no ecryption)\n" + "\ndocusafe:\n  storeconnection:\n    mongo:\n      database: (mandatory)\n      host: (mandatory)\n      port: (mandatory)\n      user: (optional)\n      password: (optional)\n      encryptionpassword: (optional. null means no ecryption)\n";
        LOGGER.error(message);
        throw new BaseException(emessage);
    }
}

