/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.spring.config;

import org.adorsys.cryptoutils.exceptions.BaseException;
import org.adorsys.docusafe.business.DocumentSafeService;
import org.adorsys.docusafe.business.impl.DocumentSafeServiceImpl;
import org.adorsys.docusafe.business.impl.WithCache;
import org.adorsys.docusafe.cached.transactional.CachedTransactionalDocumentSafeService;
import org.adorsys.docusafe.cached.transactional.impl.CachedTransactionalDocumentSafeServiceImpl;
import org.adorsys.docusafe.spring.SimpleRequestMemoryContextImpl;
import org.adorsys.docusafe.spring.annotation.UseDocusafeCachedTransactional;
import org.adorsys.docusafe.spring.annotation.UseExtendedStoreConnection;
import org.adorsys.docusafe.transactional.RequestMemoryContext;
import org.adorsys.docusafe.transactional.TransactionalDocumentSafeService;
import org.adorsys.docusafe.transactional.impl.TransactionalDocumentSafeServiceImpl;
import org.adorsys.encobject.service.api.ExtendedStoreConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@UseExtendedStoreConnection
@Configuration
public class UseDocusafeCachedTransactionalConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(UseDocusafeCachedTransactional.class);

    @Bean
    public CachedTransactionalDocumentSafeService docusafeCachedTransactionalService(ExtendedStoreConnection extendedStoreConnection, @Value(value="${docusafe.cache:true}") Boolean withCache) {
        if (extendedStoreConnection == null) {
            throw new BaseException("Injection did not work");
        }
        LOGGER.debug("create documentSafeService");
        DocumentSafeServiceImpl documentSafeService = new DocumentSafeServiceImpl(withCache != false ? WithCache.TRUE : WithCache.FALSE, extendedStoreConnection);
        SimpleRequestMemoryContextImpl requestContext = new SimpleRequestMemoryContextImpl();
        LOGGER.debug("create transactionalDocumentSafeService");
        TransactionalDocumentSafeServiceImpl transactionalDocumentSafeService = new TransactionalDocumentSafeServiceImpl((RequestMemoryContext)requestContext, (DocumentSafeService)documentSafeService);
        LOGGER.debug("create cachedTransactionalDocumentSafeService");
        CachedTransactionalDocumentSafeServiceImpl cachedTransactionalDocumentSafeService = new CachedTransactionalDocumentSafeServiceImpl((RequestMemoryContext)requestContext, (TransactionalDocumentSafeService)transactionalDocumentSafeService);
        return cachedTransactionalDocumentSafeService;
    }
}

