/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.spring.config;

import java.net.URL;
import org.adorsys.cryptoutils.exceptions.BaseExceptionHandler;
import org.adorsys.docusafe.spring.config.SpringConnectionPropertiesImpl;
import org.adorsys.encobject.types.connection.MinioAccessKey;
import org.adorsys.encobject.types.connection.MinioRootBucketName;
import org.adorsys.encobject.types.connection.MinioSecretKey;
import org.adorsys.encobject.types.properties.MinioConnectionProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

@Component
@ConfigurationProperties(prefix="docusafe.storeconnection.minio")
@Validated
public class SpringMinioConnectionProperties
extends SpringConnectionPropertiesImpl
implements MinioConnectionProperties {
    public static final String template = "\ndocusafe:\n  storeconnection:\n    minio:\n      url: (mandatory)\n      accesskey: (mandatory)\n      secretkey: (mandatory)\n      rootbucket: (optional)\n      encryptionpassword: (optional. null means no ecryption)\n";
    private String url;
    private String rootbucket = defaultBucketname.getValue();
    private String accesskey;
    private String secretkey;

    public URL getUrl() {
        try {
            return new URL(this.url);
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public MinioRootBucketName getMinioRootBucketName() {
        return new MinioRootBucketName(this.rootbucket);
    }

    public MinioAccessKey getMinioAccessKey() {
        return new MinioAccessKey(this.accesskey);
    }

    public MinioSecretKey getMinioSecretKey() {
        return new MinioSecretKey(this.secretkey);
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setRootbucket(String rootbucket) {
        this.rootbucket = rootbucket;
    }

    public void setAccesskey(String accesskey) {
        this.accesskey = accesskey;
    }

    public void setSecretkey(String secretkey) {
        this.secretkey = secretkey;
    }
}

