/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.spring.config;

import java.net.URL;
import org.adorsys.cryptoutils.exceptions.BaseExceptionHandler;
import org.adorsys.docusafe.spring.config.SpringConnectionPropertiesImpl;
import org.adorsys.encobject.types.connection.AmazonS3AccessKey;
import org.adorsys.encobject.types.connection.AmazonS3Region;
import org.adorsys.encobject.types.connection.AmazonS3RootBucketName;
import org.adorsys.encobject.types.connection.AmazonS3SecretKey;
import org.adorsys.encobject.types.properties.AmazonS3ConnectionProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

@Component
@ConfigurationProperties(prefix="docusafe.storeconnection.amazons3")
@Validated
public class SpringAmazonS3ConnectionProperties
extends SpringConnectionPropertiesImpl
implements AmazonS3ConnectionProperties {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringAmazonS3ConnectionProperties.class);
    public static final String template = "\ndocusafe:\n  storeconnection:\n    amazons3\n      url: (mandatory)\n      accesskey: (mandatory)\n      secretkey: (mandatory)\n      region: (optional)\n      rootbucket: (optional)\n      encryptionpassword: (optional. null means no ecryption)\n";
    private String url;
    private String accesskey;
    private String secretkey;
    private String region = defaultRegion.getValue();
    @Nullable
    private String rootbucket = defaultRootBucketName.getValue();

    public URL getUrl() {
        try {
            LOGGER.debug("url is:\"" + this.url + "\"");
            return new URL(this.url);
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public AmazonS3AccessKey getAmazonS3AccessKey() {
        LOGGER.debug("accesskey is:\"" + new AmazonS3AccessKey(this.accesskey) + "\"");
        return new AmazonS3AccessKey(this.accesskey);
    }

    public AmazonS3SecretKey getAmazonS3SecretKey() {
        LOGGER.debug("secretkey is:\"" + new AmazonS3SecretKey(this.secretkey) + "\"");
        return new AmazonS3SecretKey(this.secretkey);
    }

    public AmazonS3Region getAmazonS3Region() {
        LOGGER.debug("region is:\"" + new AmazonS3Region(this.region) + "\"");
        return new AmazonS3Region(this.region);
    }

    public AmazonS3RootBucketName getAmazonS3RootBucketName() {
        LOGGER.debug("rootbucket is:\"" + this.rootbucket + "\"");
        return new AmazonS3RootBucketName(this.rootbucket);
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setSecretkey(String secretkey) {
        this.secretkey = secretkey;
    }

    public void setAccesskey(String accesskey) {
        this.accesskey = accesskey;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setRootbucket(String rootbucket) {
        this.rootbucket = rootbucket;
    }
}

