/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.spring.config;

import org.adorsys.docusafe.spring.config.SpringConnectionPropertiesImpl;
import org.adorsys.encobject.types.connection.MongoURI;
import org.adorsys.encobject.types.properties.MongoConnectionProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

@Component
@ConfigurationProperties(prefix="docusafe.storeconnection.mongo")
@Validated
public class SpringMongoConnectionProperties
extends SpringConnectionPropertiesImpl
implements MongoConnectionProperties {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringMongoConnectionProperties.class);
    public static final String template = "\ndocusafe:\n  storeconnection:\n    mongo:\n      mongoURI: (mandatory)\n                (<mongoClientUri> (mongodb://[username:password@]host1[:port1][,host2[:port2],...[,hostN[:portN]]][/[database.collection][?options]]) - see http://mongodb.github.io/mongo-java-driver/3.6/javadoc/com/mongodb/MongoClientURI.html)\n      encryptionpassword: (optional. null means no ecryption)\n      encryptionfilenameonly: (optional. TRUE means, path is not encrypted)";
    private String mongoURI;

    public MongoURI getMongoURI() {
        return new MongoURI(this.mongoURI);
    }

    public void setMongoURI(String mongoURI) {
        this.mongoURI = mongoURI;
    }
}

