/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.spring.config;

import de.adorsys.common.exceptions.BaseException;
import de.adorsys.dfs.connection.api.types.connection.FilesystemRootBucketName;
import de.adorsys.dfs.connection.api.types.properties.FilesystemConnectionProperties;
import org.adorsys.docusafe.spring.config.SpringConnectionPropertiesImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

@Component
@ConfigurationProperties(prefix="docusafe.storeconnection.filesystem")
@Validated
public class SpringFilesystemConnectionProperties
extends SpringConnectionPropertiesImpl
implements FilesystemConnectionProperties {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringFilesystemConnectionProperties.class);
    public static final String template = "\ndocusafe:\n  storeconnection:\n    filesystem:\n      rootbucket: (mandatory)\n";
    private String rootbucket;

    public FilesystemRootBucketName getFilesystemRootBucketName() {
        if (this.rootbucket == null) {
            throw new BaseException("basedir must not be null");
        }
        LOGGER.debug("basedir:" + new FilesystemRootBucketName(this.rootbucket));
        return new FilesystemRootBucketName(this.rootbucket);
    }

    public void setRootbucket(String rootbucket) {
        this.rootbucket = rootbucket;
    }
}

