/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.spring.config;

import de.adorsys.dfs.connection.api.service.api.DFSConnection;
import org.adorsys.docusafe.cached.transactional.CachedTransactionalDocumentSafeService;
import org.adorsys.docusafe.spring.config.SpringDFSConnectionProperties;
import org.adorsys.docusafe.spring.factory.SpringCachedTransactionalDocusafeServiceFactory;
import org.adorsys.docusafe.spring.factory.SpringDFSConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DocusafeSpringBeans {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocusafeSpringBeans.class);

    public DocusafeSpringBeans() {
        LOGGER.info("INIT");
    }

    @Bean
    public DFSConnection DFSConnection(SpringDFSConnectionFactory factory) {
        LOGGER.info(DFSConnection.class.getName() + " is required as @Bean");
        return factory.getDFSConnectionWithSubDir(null);
    }

    @Bean
    public SpringDFSConnectionFactory springDFSConnectionFactory(SpringDFSConnectionProperties properties) {
        LOGGER.info(SpringDFSConnectionFactory.class.getName() + " is required as @Bean");
        return new SpringDFSConnectionFactory(properties);
    }

    @Bean
    public SpringCachedTransactionalDocusafeServiceFactory springCachedTransactionalDocusafeServiceFactory(SpringDFSConnectionFactory connectionFactory) {
        LOGGER.info(SpringCachedTransactionalDocusafeServiceFactory.class.getName() + " is required as @Bean");
        return new SpringCachedTransactionalDocusafeServiceFactory(connectionFactory);
    }

    @Bean
    public CachedTransactionalDocumentSafeService cachedTransactionalDocumentSafeService(SpringCachedTransactionalDocusafeServiceFactory springCachedTransactionalDocusafeServiceFactory, @Value(value="${docusafe.cache:true}") Boolean withCache) {
        LOGGER.info(CachedTransactionalDocumentSafeService.class.getName() + " is required as @Bean");
        return springCachedTransactionalDocusafeServiceFactory.getCachedTransactionalDocumentSafeServiceWithSubdir(null);
    }
}

