/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.docusafe.service.impl.keystore.service;

import de.adorsys.common.exceptions.BaseException;
import de.adorsys.common.exceptions.BaseExceptionHandler;
import de.adorsys.common.utils.HexUtil;
import de.adorsys.docusafe.service.api.keystore.KeyStoreService;
import de.adorsys.docusafe.service.api.keystore.types.KeyID;
import de.adorsys.docusafe.service.api.keystore.types.KeyStoreAccess;
import de.adorsys.docusafe.service.api.keystore.types.KeyStoreAuth;
import de.adorsys.docusafe.service.api.keystore.types.KeyStoreCreationConfig;
import de.adorsys.docusafe.service.api.keystore.types.KeyStoreType;
import de.adorsys.docusafe.service.api.keystore.types.PublicKeyIDWithPublicKey;
import de.adorsys.docusafe.service.api.keystore.types.PublicKeyList;
import de.adorsys.docusafe.service.api.keystore.types.ReadKeyPassword;
import de.adorsys.docusafe.service.api.keystore.types.SecretKeyIDWithKey;
import de.adorsys.docusafe.service.impl.keystore.generator.KeyStoreGenerator;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.UUID;
import javax.crypto.SecretKey;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreServiceImpl
implements KeyStoreService {
    private static final Logger log = LoggerFactory.getLogger(KeyStoreServiceImpl.class);

    @Override
    public KeyStore createKeyStore(KeyStoreAuth keyStoreAuth, KeyStoreType keyStoreType, KeyStoreCreationConfig config) {
        try {
            log.debug("start create keystore ");
            if (config == null) {
                config = new KeyStoreCreationConfig(5, 5, 5);
            }
            String serverKeyPairAliasPrefix = HexUtil.convertBytesToHexString((byte[])UUID.randomUUID().toString().getBytes());
            log.debug("keystoreid = " + serverKeyPairAliasPrefix);
            String realKeyStoreId = new String(HexUtil.convertHexStringToBytes((String)serverKeyPairAliasPrefix));
            log.debug("meaning of keystoreid = " + realKeyStoreId);
            KeyStoreGenerator keyStoreGenerator = new KeyStoreGenerator(config, keyStoreType, serverKeyPairAliasPrefix, keyStoreAuth.getReadKeyPassword());
            KeyStore userKeyStore = keyStoreGenerator.generate();
            log.debug("finished create keystore ");
            return userKeyStore;
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    @Override
    public PublicKeyList getPublicKeys(KeyStoreAccess keyStoreAccess) {
        try {
            log.debug("get public keys");
            PublicKeyList result = new PublicKeyList();
            KeyStore keyStore = keyStoreAccess.getKeyStore();
            Enumeration<String> keyAliases = keyStore.aliases();
            while (keyAliases.hasMoreElements()) {
                boolean[] keyUsage;
                String keyAlias = keyAliases.nextElement();
                X509Certificate cert = (X509Certificate)keyStore.getCertificate(keyAlias);
                if (cert == null || !(keyUsage = cert.getKeyUsage())[2] && !keyUsage[3] && !keyUsage[4]) continue;
                result.add(new PublicKeyIDWithPublicKey(new KeyID(keyAlias), cert.getPublicKey()));
            }
            return result;
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    @Override
    public PrivateKey getPrivateKey(KeyStoreAccess keyStoreAccess, KeyID keyID) {
        try {
            ReadKeyPassword readKeyPassword = keyStoreAccess.getKeyStoreAuth().getReadKeyPassword();
            KeyStore keyStore = keyStoreAccess.getKeyStore();
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(keyID.getValue(), readKeyPassword.getValue().toCharArray());
            return privateKey;
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    @Override
    public SecretKey getSecretKey(KeyStoreAccess keyStoreAccess, KeyID keyID) {
        try {
            KeyStore keyStore = keyStoreAccess.getKeyStore();
            Object key = null;
            char[] password = keyStoreAccess.getKeyStoreAuth().getReadKeyPassword().getValue().toCharArray();
            return (SecretKey)keyStore.getKey(keyID.getValue(), password);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    @Override
    public SecretKeyIDWithKey getRandomSecretKeyID(KeyStoreAccess keyStoreAccess) {
        try {
            KeyStore keyStore = keyStoreAccess.getKeyStore();
            Key key = null;
            String randomAlias = null;
            Enumeration<String> aliases = keyStore.aliases();
            ArrayList<String> keyIDs = new ArrayList<String>();
            for (String keyAlias : Collections.list(aliases)) {
                if (!keyStore.entryInstanceOf(keyAlias, KeyStore.SecretKeyEntry.class)) continue;
                keyIDs.add(keyAlias);
            }
            if (keyIDs.size() == 0) {
                throw new BaseException("No secret keys in the keystore");
            }
            int randomIndex = RandomUtils.nextInt((int)0, (int)keyIDs.size());
            randomAlias = (String)keyIDs.get(randomIndex);
            char[] password = keyStoreAccess.getKeyStoreAuth().getReadKeyPassword().getValue().toCharArray();
            key = keyStore.getKey(randomAlias, password);
            return new SecretKeyIDWithKey(new KeyID(randomAlias), (SecretKey)key);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }
}

