/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.docusafe.service.impl.keystore.generator;

import de.adorsys.docusafe.service.impl.keystore.generator.KeyEntryData;
import de.adorsys.docusafe.service.impl.keystore.generator.TrustedCertEntry;
import javax.security.auth.callback.CallbackHandler;
import org.bouncycastle.cert.X509CertificateHolder;

public class TrustedCertData
extends KeyEntryData
implements TrustedCertEntry {
    private final X509CertificateHolder certificate;

    private TrustedCertData(CallbackHandler passwordSource, String alias, X509CertificateHolder certificate) {
        super(passwordSource, alias);
        this.certificate = certificate;
    }

    public static TrustedCertDataBuilder builder() {
        return new TrustedCertDataBuilder();
    }

    @Override
    public X509CertificateHolder getCertificate() {
        return this.certificate;
    }

    public static class TrustedCertDataBuilder {
        private CallbackHandler passwordSource;
        private String alias;
        private X509CertificateHolder certificate;

        TrustedCertDataBuilder() {
        }

        public TrustedCertDataBuilder passwordSource(CallbackHandler passwordSource) {
            this.passwordSource = passwordSource;
            return this;
        }

        public TrustedCertDataBuilder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public TrustedCertDataBuilder certificate(X509CertificateHolder certificate) {
            this.certificate = certificate;
            return this;
        }

        public TrustedCertData build() {
            return new TrustedCertData(this.passwordSource, this.alias, this.certificate);
        }

        public String toString() {
            return "TrustedCertData.TrustedCertDataBuilder(passwordSource=" + this.passwordSource + ", alias=" + this.alias + ", certificate=" + this.certificate + ")";
        }
    }
}

