/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.docusafe.service.impl.keystore.generator;

import de.adorsys.docusafe.service.api.keystore.types.KeyEntry;
import de.adorsys.docusafe.service.api.keystore.types.KeyStoreType;
import de.adorsys.docusafe.service.impl.keystore.generator.KeyStoreServiceImplBaseFunctions;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;

public class KeystoreBuilder {
    private KeyStoreType storeType;
    private String storeId;
    private Map<String, KeyEntry> keyEntries = new HashMap<String, KeyEntry>();

    public KeystoreBuilder withStoreType(KeyStoreType storeType) {
        this.storeType = storeType;
        return this;
    }

    public KeystoreBuilder withStoreId(String storeId) {
        this.storeId = storeId;
        return this;
    }

    public KeystoreBuilder withKeyEntry(KeyEntry keyEntry) {
        this.keyEntries.put(keyEntry.getAlias(), keyEntry);
        return this;
    }

    public byte[] build(CallbackHandler storePassSrc) {
        KeyStore ks = KeyStoreServiceImplBaseFunctions.newKeyStore(this.storeType);
        KeyStoreServiceImplBaseFunctions.fillKeyStore(ks, this.keyEntries.values());
        return KeyStoreServiceImplBaseFunctions.toByteArray(ks, this.storeId, storePassSrc);
    }

    public KeyStore build() {
        KeyStore ks = KeyStoreServiceImplBaseFunctions.newKeyStore(this.storeType);
        KeyStoreServiceImplBaseFunctions.fillKeyStore(ks, this.keyEntries.values());
        return ks;
    }
}

