/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.docusafe.service.impl.keystore.generator;

import org.bouncycastle.asn1.crmf.CertTemplate;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.cert.X509CertificateHolder;

public class KeyUsageUtils {
    public static int getKeyUsage(X509CertificateHolder issuerCertificate) {
        Extension keyUsageExtension = issuerCertificate.getExtension(X509Extension.keyUsage);
        return KeyUsageUtils.extractKeyUsage(keyUsageExtension);
    }

    private static int extractKeyUsage(Extension keyUsageExtension) {
        if (keyUsageExtension != null) {
            KeyUsage ku = KeyUsage.getInstance((Object)keyUsageExtension.getParsedValue().toASN1Primitive());
            return ku.getBytes()[0] & 0xFF;
        }
        return -1;
    }

    public static final boolean hasAllKeyUsage(X509CertificateHolder holder, int ... keyUsageBits) {
        Extension extension = holder.getExtension(X509Extension.keyUsage);
        return KeyUsageUtils.hasAllKeyUsage(extension, keyUsageBits);
    }

    public static final boolean hasAllKeyUsage(CertTemplate certTemplate, int ... keyUsageBits) {
        Extensions extensions = certTemplate.getExtensions();
        Extension extension = extensions.getExtension(X509Extension.keyUsage);
        return KeyUsageUtils.hasAllKeyUsage(extension, keyUsageBits);
    }

    private static final boolean hasAllKeyUsage(Extension extension, int ... keyUsageBits) {
        if (extension != null) {
            KeyUsage ku = KeyUsage.getInstance((Object)extension.getParsedValue());
            int bits = ku.getBytes()[0] & 0xFF;
            if (keyUsageBits.length <= 0) {
                return false;
            }
            for (int keyUsageBit : keyUsageBits) {
                if ((bits & keyUsageBit) == keyUsageBit) continue;
                return false;
            }
            return true;
        }
        return keyUsageBits.length <= 0;
    }

    public static final boolean hasAnyKeyUsage(X509CertificateHolder holder, int ... keyUsageBits) {
        if (keyUsageBits.length <= 0) {
            return true;
        }
        Extension extension = holder.getExtension(X509Extension.keyUsage);
        return KeyUsageUtils.hasAnyKeyUsage(extension, keyUsageBits);
    }

    public static final boolean hasAnyKeyUsage(CertTemplate certTemplate, int ... keyUsageBits) {
        if (keyUsageBits.length <= 0) {
            return true;
        }
        Extensions extensions = certTemplate.getExtensions();
        Extension extension = extensions.getExtension(X509Extension.keyUsage);
        return KeyUsageUtils.hasAnyKeyUsage(extension, keyUsageBits);
    }

    private static final boolean hasAnyKeyUsage(Extension extension, int ... keyUsageBits) {
        if (extension != null) {
            KeyUsage ku = KeyUsage.getInstance((Object)extension.getParsedValue());
            int bits = ku.getBytes()[0] & 0xFF;
            for (int keyUsageBit : keyUsageBits) {
                if ((bits & keyUsageBit) != keyUsageBit) continue;
                return true;
            }
        }
        return false;
    }

    public static final int[] getStdKeyUsages() {
        return new int[]{128, 64, 32};
    }

    public static final int[] getCaKeyUsages() {
        return new int[]{4};
    }
}

