/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.docusafe.service.impl.keystore.generator;

import de.adorsys.docusafe.service.api.keystore.types.KeyStoreCreationConfig;
import de.adorsys.docusafe.service.impl.keystore.generator.KeyPairGeneratorImpl;
import de.adorsys.docusafe.service.impl.keystore.generator.SecretKeyGeneratorImpl;

public class KeyStoreCreationConfigImpl {
    private final KeyStoreCreationConfig config;

    public KeyStoreCreationConfigImpl(KeyStoreCreationConfig config) {
        this.config = config;
    }

    public KeyPairGeneratorImpl getEncKeyPairGenerator(String keyPrefix) {
        return new KeyPairGeneratorImpl("RSA", 2048, "SHA256withRSA", "enc-" + keyPrefix);
    }

    public KeyPairGeneratorImpl getSignKeyPairGenerator(String keyPrefix) {
        return new KeyPairGeneratorImpl("RSA", 2048, "SHA256withRSA", "sign-" + keyPrefix);
    }

    public SecretKeyGeneratorImpl getSecretKeyGenerator(String keyPrefix) {
        return new SecretKeyGeneratorImpl("AES", 256);
    }

    public Integer getEncKeyNumber() {
        return this.config.getEncKeyNumber();
    }

    public Integer getSignKeyNumber() {
        return this.config.getSignKeyNumber();
    }

    public Integer getSecretKeyNumber() {
        return this.config.getSecretKeyNumber();
    }
}

