/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.docusafe.service.impl.keystore.generator;

import de.adorsys.docusafe.service.api.keystore.types.KeyPairGenerator;
import de.adorsys.docusafe.service.api.keystore.types.SelfSignedKeyPairData;
import de.adorsys.docusafe.service.impl.keystore.generator.KeyPairBuilder;
import de.adorsys.docusafe.service.impl.keystore.generator.KeyPairData;
import de.adorsys.docusafe.service.impl.keystore.generator.SingleKeyUsageSelfSignedCertBuilder;
import java.security.KeyPair;
import javax.security.auth.callback.CallbackHandler;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;

public class KeyPairGeneratorImpl
implements KeyPairGenerator {
    private static final int[] keyUsageSignature = new int[]{64};
    private static final int[] keyUsageEncryption = new int[]{32, 16, 8};
    private final String keyAlgo;
    private final Integer keySize;
    private final String serverSigAlgo;
    private final String serverKeyPairName;

    public KeyPairGeneratorImpl(String keyAlgo, Integer keySize, String serverSigAlgo, String serverKeyPairName) {
        this.keyAlgo = keyAlgo;
        this.keySize = keySize;
        this.serverSigAlgo = serverSigAlgo;
        this.serverKeyPairName = serverKeyPairName;
    }

    @Override
    public KeyPairData generateSignatureKey(String alias, CallbackHandler keyPassHandler) {
        return this.generate(keyUsageSignature, alias, keyPassHandler);
    }

    @Override
    public KeyPairData generateEncryptionKey(String alias, CallbackHandler keyPassHandler) {
        return this.generate(keyUsageEncryption, alias, keyPassHandler);
    }

    private KeyPairData generate(int[] keyUsages, String alias, CallbackHandler keyPassHandler) {
        KeyPair keyPair = new KeyPairBuilder().withKeyAlg(this.keyAlgo).withKeyLength(this.keySize).build();
        X500Name dn = new X500NameBuilder(BCStyle.INSTANCE).addRDN(BCStyle.CN, this.serverKeyPairName).build();
        SelfSignedKeyPairData keyPairData = new SingleKeyUsageSelfSignedCertBuilder().withSubjectDN(dn).withSignatureAlgo(this.serverSigAlgo).withNotAfterInDays(900).withCa(false).withKeyUsages(keyUsages).build(keyPair);
        return KeyPairData.builder().keyPair(keyPairData).alias(alias).passwordSource(keyPassHandler).build();
    }
}

