/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.docusafe.service.impl.keystore.generator;

import de.adorsys.docusafe.service.impl.keystore.generator.CertVerifier;
import de.adorsys.docusafe.service.impl.keystore.generator.KeyIdUtils;
import de.adorsys.docusafe.service.impl.keystore.generator.KeyUsageUtils;
import java.util.Arrays;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.cert.X509CertificateHolder;

public class CheckCaCertificate {
    public static boolean isSigingCertificate(X509CertificateHolder signed, X509CertificateHolder signer) {
        if (!signed.getIssuer().equals((Object)signer.getSubject())) {
            return false;
        }
        AuthorityKeyIdentifier authorityKeyIdentifier = KeyIdUtils.readAuthorityKeyIdentifier(signed);
        if (authorityKeyIdentifier == null) {
            return false;
        }
        SubjectKeyIdentifier subjectKeyIdentifier = KeyIdUtils.readSubjectKeyIdentifier(signer);
        if (!Arrays.equals(subjectKeyIdentifier.getKeyIdentifier(), authorityKeyIdentifier.getKeyIdentifier())) {
            return false;
        }
        if (!signer.getSerialNumber().equals(authorityKeyIdentifier.getAuthorityCertSerialNumber())) {
            return false;
        }
        return CertVerifier.verify(signed, signer);
    }

    public static boolean isCaCertificate(X509CertificateHolder issuerCertificate) {
        Extension basicConstraintsExtension = issuerCertificate.getExtension(X509Extension.basicConstraints);
        BasicConstraints issuerBasicConstraints = BasicConstraints.getInstance((Object)basicConstraintsExtension.getParsedValue());
        if (!issuerBasicConstraints.isCA()) {
            return false;
        }
        int ku = KeyUsageUtils.getKeyUsage(issuerCertificate);
        return (4 & ku) > 0;
    }
}

