/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.docusafe.service.impl.cmsencryption.services;

import de.adorsys.common.exceptions.BaseExceptionHandler;
import de.adorsys.dfs.connection.api.domain.Payload;
import de.adorsys.dfs.connection.api.service.impl.SimplePayloadImpl;
import de.adorsys.docusafe.service.api.cmsencryption.CMSEncryptionService;
import de.adorsys.docusafe.service.api.exceptions.DecryptionException;
import de.adorsys.docusafe.service.api.keystore.types.KeyID;
import de.adorsys.docusafe.service.api.keystore.types.KeyStoreAccess;
import de.adorsys.docusafe.service.impl.cmsencryption.exceptions.AsymmetricEncryptionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.util.Iterator;
import javax.crypto.SecretKey;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSEnvelopedDataParser;
import org.bouncycastle.cms.CMSEnvelopedDataStreamGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.KEKRecipientId;
import org.bouncycastle.cms.KeyTransRecipientId;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKEKEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKEKRecipientInfoGenerator;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.operator.OutputEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMSEncryptionServiceImpl
implements CMSEncryptionService {
    private static final Logger log = LoggerFactory.getLogger(CMSEncryptionServiceImpl.class);

    @Override
    public CMSEnvelopedData encrypt(Payload payload, PublicKey publicKey, KeyID publicKeyId) {
        try {
            CMSEnvelopedDataGenerator cmsEnvelopedDataGenerator = new CMSEnvelopedDataGenerator();
            JceKeyTransRecipientInfoGenerator jceKey = new JceKeyTransRecipientInfoGenerator(publicKeyId.getValue().getBytes(), publicKey);
            cmsEnvelopedDataGenerator.addRecipientInfoGenerator((RecipientInfoGenerator)jceKey);
            CMSProcessableByteArray msg = new CMSProcessableByteArray(payload.getData());
            OutputEncryptor encryptor = new JceCMSContentEncryptorBuilder(CMSAlgorithm.AES128_CBC).setProvider("BC").build();
            return cmsEnvelopedDataGenerator.generate((CMSTypedData)msg, encryptor);
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    @Override
    public Payload decrypt(CMSEnvelopedData cmsEnvelopedData, KeyStoreAccess keyStoreAccess) {
        try {
            RecipientInformationStore recipients = cmsEnvelopedData.getRecipientInfos();
            Iterator recipientInformationIterator = recipients.getRecipients().iterator();
            if (!recipientInformationIterator.hasNext()) {
                throw new AsymmetricEncryptionException("CMS Envelope doesn't contain recipients");
            }
            RecipientInformation recipientInfo = (RecipientInformation)recipientInformationIterator.next();
            if (recipientInformationIterator.hasNext()) {
                throw new AsymmetricEncryptionException("PROGRAMMING ERROR. HANDLE OF MORE THAN ONE RECIPIENT NOT DONE YET");
            }
            KeyTransRecipientId recipientId = (KeyTransRecipientId)recipientInfo.getRID();
            byte[] subjectKeyIdentifier = recipientId.getSubjectKeyIdentifier();
            String keyId = new String(subjectKeyIdentifier);
            log.debug("Private key ID from envelope: {}", (Object)keyId);
            PrivateKey privateKey = (PrivateKey)keyStoreAccess.getKeyStore().getKey(keyId, keyStoreAccess.getKeyStoreAuth().getReadKeyPassword().getValue().toCharArray());
            JceKeyTransEnvelopedRecipient recipient = new JceKeyTransEnvelopedRecipient(privateKey);
            return new SimplePayloadImpl(recipientInfo.getContent((Recipient)recipient));
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputStream buildEncryptionInputStream(InputStream is, PublicKey publicKey, KeyID publicKeyID) {
        try {
            File file = File.createTempFile("fos-encrypted-", "");
            try (MyFileOutputStream fos = new MyFileOutputStream(file);){
                JceKeyTransRecipientInfoGenerator rec = new JceKeyTransRecipientInfoGenerator(publicKeyID.getValue().getBytes(), publicKey);
                this.readFromInputStreamAndWriteToOutputStream(is, fos, (RecipientInfoGenerator)rec);
                MyFileInputStream myFileInputStream = new MyFileInputStream(file);
                return myFileInputStream;
            }
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    @Override
    public InputStream buildEncryptionInputStream(InputStream is, SecretKey secretKey, KeyID keyID) {
        try {
            File file = File.createTempFile("fos-encrypted-", "");
            try (MyFileOutputStream fos = new MyFileOutputStream(file);){
                JceKEKRecipientInfoGenerator rec = new JceKEKRecipientInfoGenerator(keyID.getValue().getBytes(), secretKey);
                this.readFromInputStreamAndWriteToOutputStream(is, fos, (RecipientInfoGenerator)rec);
            }
            return new MyFileInputStream(file);
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    @Override
    public InputStream buildDecryptionInputStream(InputStream inputStream, KeyStoreAccess keyStoreAccess) {
        try {
            RecipientInformationStore recipientInfoStore = new CMSEnvelopedDataParser(inputStream).getRecipientInfos();
            if (recipientInfoStore.size() == 0) {
                throw new DecryptionException("CMS Envelope doesn't contain recipients");
            }
            if (recipientInfoStore.size() > 1) {
                throw new DecryptionException("Programming error. Handling of more that one recipient not done yet");
            }
            RecipientInformation recipientInfo = (RecipientInformation)recipientInfoStore.getRecipients().stream().findFirst().get();
            RecipientId rid = recipientInfo.getRID();
            switch (rid.getType()) {
                case 0: {
                    return recipientInfo.getContentStream((Recipient)new JceKeyTransEnvelopedRecipient(this.privateKey(keyStoreAccess, rid))).getContentStream();
                }
                case 1: {
                    return recipientInfo.getContentStream((Recipient)new JceKEKEnvelopedRecipient(this.secretKey(keyStoreAccess, rid))).getContentStream();
                }
            }
            throw new DecryptionException("Programming error. Handling of more that one recipient not done yet");
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    private SecretKey secretKey(KeyStoreAccess keyStoreAccess, RecipientId rid) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String keyIdentifier = new String(((KEKRecipientId)rid).getKeyIdentifier());
        log.debug("Secret key ID from envelope: {}", (Object)keyIdentifier);
        return (SecretKey)keyStoreAccess.getKeyStore().getKey(keyIdentifier, keyStoreAccess.getKeyStoreAuth().getReadKeyPassword().getValue().toCharArray());
    }

    private PrivateKey privateKey(KeyStoreAccess keyStoreAccess, RecipientId rid) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String subjectKeyIdentifier = new String(((KeyTransRecipientId)rid).getSubjectKeyIdentifier());
        log.debug("Private key ID from envelope: {}", (Object)subjectKeyIdentifier);
        return (PrivateKey)keyStoreAccess.getKeyStore().getKey(subjectKeyIdentifier, keyStoreAccess.getKeyStoreAuth().getReadKeyPassword().getValue().toCharArray());
    }

    private OutputStream streamEncrypt(OutputStream dataContentStream, RecipientInfoGenerator rec) throws CMSException, IOException {
        CMSEnvelopedDataStreamGenerator gen = new CMSEnvelopedDataStreamGenerator();
        gen.addRecipientInfoGenerator(rec);
        return gen.open(dataContentStream, new JceCMSContentEncryptorBuilder(CMSAlgorithm.AES128_CBC).setProvider("BC").build());
    }

    private void readFromInputStreamAndWriteToOutputStream(InputStream is, FileOutputStream fos, RecipientInfoGenerator rec) {
        try {
            int content;
            OutputStream os = this.streamEncrypt(fos, rec);
            byte[] buffer = new byte[8192];
            while ((content = is.read(buffer)) != -1) {
                os.write(buffer, 0, content);
            }
            os.flush();
            IOUtils.closeQuietly((OutputStream)os);
            IOUtils.closeQuietly((OutputStream)fos);
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public static class MyFileOutputStream
    extends FileOutputStream {
        private static final Logger LOGGER = LoggerFactory.getLogger(MyFileOutputStream.class);
        File file = null;

        public MyFileOutputStream(File file) throws FileNotFoundException {
            super(file);
            this.file = file;
            LOGGER.debug("temp fos is " + file);
        }

        @Override
        public void close() {
            try {
                LOGGER.debug("close fos " + this.file);
                super.close();
            }
            catch (Exception e) {
                BaseExceptionHandler.handle((Throwable)e);
            }
        }
    }

    public static class MyFileInputStream
    extends FileInputStream {
        private static final Logger LOGGER = LoggerFactory.getLogger(MyFileInputStream.class);
        File file = null;
        boolean hereItBecomeseUgly = false;

        public MyFileInputStream(File file) throws FileNotFoundException {
            super(file);
            this.file = file;
            LOGGER.debug("temp fis " + file);
        }

        @Override
        public void close() {
            if (this.hereItBecomeseUgly) {
                return;
            }
            try {
                LOGGER.debug("close fis " + this.file);
                this.hereItBecomeseUgly = true;
                super.close();
                this.hereItBecomeseUgly = false;
                LOGGER.debug("closed fis " + this.file);
                this.delete();
            }
            catch (Exception e) {
                BaseExceptionHandler.handle((Throwable)e);
            }
        }

        public void delete() {
            try {
                if (this.file != null) {
                    LOGGER.debug("delete file " + this.file);
                    FileUtils.forceDelete((File)this.file);
                    LOGGER.debug("deleted file " + this.file);
                    this.file = null;
                }
            }
            catch (Exception e) {
                BaseExceptionHandler.handle((Throwable)e);
            }
        }
    }
}

