/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.docusafe.service.api.types;

import de.adorsys.docusafe.service.api.keystore.types.KeyID;
import java.beans.ConstructorProperties;
import java.security.PublicKey;
import lombok.NonNull;

public final class PublicKeyWithId {
    @NonNull
    private final PublicKey publicKey;
    @NonNull
    private final KeyID publicKeyId;

    @ConstructorProperties(value={"publicKey", "publicKeyId"})
    PublicKeyWithId(@NonNull PublicKey publicKey, @NonNull KeyID publicKeyId) {
        if (publicKey == null) {
            throw new NullPointerException("publicKey");
        }
        if (publicKeyId == null) {
            throw new NullPointerException("publicKeyId");
        }
        this.publicKey = publicKey;
        this.publicKeyId = publicKeyId;
    }

    public static PublicKeyWithIdBuilder builder() {
        return new PublicKeyWithIdBuilder();
    }

    @NonNull
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @NonNull
    public KeyID getPublicKeyId() {
        return this.publicKeyId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PublicKeyWithId)) {
            return false;
        }
        PublicKeyWithId other = (PublicKeyWithId)o;
        PublicKey this$publicKey = this.getPublicKey();
        PublicKey other$publicKey = other.getPublicKey();
        if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
            return false;
        }
        KeyID this$publicKeyId = this.getPublicKeyId();
        KeyID other$publicKeyId = other.getPublicKeyId();
        return !(this$publicKeyId == null ? other$publicKeyId != null : !((Object)((Object)this$publicKeyId)).equals((Object)other$publicKeyId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PublicKey $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        KeyID $publicKeyId = this.getPublicKeyId();
        result = result * 59 + ($publicKeyId == null ? 43 : ((Object)((Object)$publicKeyId)).hashCode());
        return result;
    }

    public String toString() {
        return "PublicKeyWithId(publicKey=" + this.getPublicKey() + ", publicKeyId=" + (Object)((Object)this.getPublicKeyId()) + ")";
    }

    public static class PublicKeyWithIdBuilder {
        private PublicKey publicKey;
        private KeyID publicKeyId;

        PublicKeyWithIdBuilder() {
        }

        public PublicKeyWithIdBuilder publicKey(PublicKey publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public PublicKeyWithIdBuilder publicKeyId(KeyID publicKeyId) {
            this.publicKeyId = publicKeyId;
            return this;
        }

        public PublicKeyWithId build() {
            return new PublicKeyWithId(this.publicKey, this.publicKeyId);
        }

        public String toString() {
            return "PublicKeyWithId.PublicKeyWithIdBuilder(publicKey=" + this.publicKey + ", publicKeyId=" + (Object)((Object)this.publicKeyId) + ")";
        }
    }
}

