/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.docusafe.service.api.keystore.types;

import de.adorsys.docusafe.service.api.exceptions.KeyStoreAuthException;
import de.adorsys.docusafe.service.api.keystore.types.ReadKeyPassword;
import de.adorsys.docusafe.service.api.keystore.types.ReadStorePassword;

public class KeyStoreAuth {
    private final ReadStorePassword readStorePassword;
    private final ReadKeyPassword readKeyPassword;

    public KeyStoreAuth(ReadStorePassword readStorePassword, ReadKeyPassword readKeyPassword) {
        this.readStorePassword = readStorePassword;
        this.readKeyPassword = readKeyPassword;
    }

    public ReadStorePassword getReadStorePassword() {
        if (this.readStorePassword == null) {
            throw new KeyStoreAuthException("Access to READ STORE PASSWORD not allowed.");
        }
        return this.readStorePassword;
    }

    public ReadKeyPassword getReadKeyPassword() {
        if (this.readKeyPassword == null) {
            throw new KeyStoreAuthException("Access to READ KEY PASSWORD not allowed");
        }
        return this.readKeyPassword;
    }

    public String toString() {
        return "KeyStoreAuth{" + (Object)((Object)this.readStorePassword) + ", " + (Object)((Object)this.readKeyPassword) + '}';
    }
}

