/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.service.serializer;

import java.util.HashMap;
import java.util.Map;
import org.adorsys.docusafe.service.exceptions.SerializationException;
import org.adorsys.docusafe.service.serializer.DocumentGuardSerializer;
import org.adorsys.docusafe.service.serializer.DocumentGuardSerializer01;

public class DocumentGuardSerializerRegistery {
    public static final String SERIALIZER_HEADER_KEY = "serilizer_id";
    private static DocumentGuardSerializerRegistery instance = new DocumentGuardSerializerRegistery();
    public Map<String, DocumentGuardSerializer> serializers = new HashMap<String, DocumentGuardSerializer>();

    public static DocumentGuardSerializerRegistery getInstance() {
        return instance;
    }

    private DocumentGuardSerializerRegistery() {
        DocumentGuardSerializer01 documentGuardSerializer01 = new DocumentGuardSerializer01();
        this.registerSerializer(documentGuardSerializer01.getSerializerID(), documentGuardSerializer01);
    }

    public DocumentGuardSerializer getSerializer(String serializerId) {
        if (!this.serializers.containsKey(serializerId)) {
            throw new SerializationException("No Serializer with id : " + serializerId + " registered.");
        }
        return this.serializers.get(serializerId);
    }

    public void registerSerializer(String serializerId, DocumentGuardSerializer serializer) {
        this.serializers.put(serializerId, serializer);
    }

    public DocumentGuardSerializer defaultSerializer() {
        return this.serializers.get("dgs01");
    }
}

