/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.service.impl;

import java.security.KeyStore;
import java.util.UUID;
import org.adorsys.cryptoutils.exceptions.BaseException;
import org.adorsys.docusafe.service.BucketService;
import org.adorsys.docusafe.service.DocumentGuardService;
import org.adorsys.docusafe.service.exceptions.NoDocumentGuardExists;
import org.adorsys.docusafe.service.impl.BucketServiceImpl;
import org.adorsys.docusafe.service.impl.GuardKeyType;
import org.adorsys.docusafe.service.impl.guardHelper.GuardKeyHelper;
import org.adorsys.docusafe.service.impl.guardHelper.GuardKeyHelperFactory;
import org.adorsys.docusafe.service.impl.guardHelper.KeySourceAndGuardKeyID;
import org.adorsys.docusafe.service.serializer.DocumentGuardSerializer;
import org.adorsys.docusafe.service.serializer.DocumentGuardSerializerRegistery;
import org.adorsys.docusafe.service.types.DocumentKey;
import org.adorsys.docusafe.service.types.DocumentKeyID;
import org.adorsys.docusafe.service.types.GuardKey;
import org.adorsys.docusafe.service.types.complextypes.DocumentGuardLocation;
import org.adorsys.docusafe.service.types.complextypes.DocumentKeyIDWithKey;
import org.adorsys.encobject.complextypes.BucketPath;
import org.adorsys.encobject.domain.KeyStoreAccess;
import org.adorsys.encobject.domain.Payload;
import org.adorsys.encobject.domain.StorageMetadata;
import org.adorsys.encobject.exceptions.FileExistsException;
import org.adorsys.encobject.service.api.EncryptedPersistenceService;
import org.adorsys.encobject.service.api.EncryptionStreamService;
import org.adorsys.encobject.service.api.ExtendedStoreConnection;
import org.adorsys.encobject.service.api.KeySource;
import org.adorsys.encobject.service.api.KeystorePersistence;
import org.adorsys.encobject.service.impl.BlobStoreKeystorePersistenceImpl;
import org.adorsys.encobject.service.impl.EncryptedPersistenceServiceImpl;
import org.adorsys.encobject.service.impl.JWEncryptionStreamServiceImpl;
import org.adorsys.encobject.service.impl.KeyStoreBasedSecretKeySourceImpl;
import org.adorsys.encobject.service.impl.SimplePayloadImpl;
import org.adorsys.encobject.service.impl.SimpleStorageMetadataImpl;
import org.adorsys.encobject.service.impl.generator.SecretKeyGeneratorImpl;
import org.adorsys.encobject.types.KeyID;
import org.adorsys.encobject.types.OverwriteFlag;
import org.adorsys.jkeygen.keystore.KeyStoreType;
import org.adorsys.jkeygen.keystore.SecretKeyData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentGuardServiceImpl
implements DocumentGuardService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentGuardServiceImpl.class);
    private static final String KEYSTORE_TYPE = "KeyStoreType";
    private KeystorePersistence keystorePersistence;
    private EncryptedPersistenceService encryptedPersistenceUtil;
    private BucketService bucketService;
    private DocumentGuardSerializerRegistery serializerRegistry = DocumentGuardSerializerRegistery.getInstance();

    public DocumentGuardServiceImpl(ExtendedStoreConnection extendedStoreConnection) {
        this.encryptedPersistenceUtil = new EncryptedPersistenceServiceImpl(extendedStoreConnection, (EncryptionStreamService)new JWEncryptionStreamServiceImpl());
        this.keystorePersistence = new BlobStoreKeystorePersistenceImpl(extendedStoreConnection);
        this.bucketService = new BucketServiceImpl(extendedStoreConnection);
    }

    @Override
    public DocumentKeyIDWithKey createDocumentKeyIdWithKey() {
        DocumentKeyID documentKeyID = new DocumentKeyID("DK" + UUID.randomUUID().toString());
        SecretKeyGeneratorImpl secretKeyGenerator = new SecretKeyGeneratorImpl("AES", Integer.valueOf(256));
        SecretKeyData secretKeyData = secretKeyGenerator.generate(documentKeyID.getValue(), null);
        DocumentKey documentKey = new DocumentKey(secretKeyData.getSecretKey());
        return new DocumentKeyIDWithKey(documentKeyID, documentKey);
    }

    @Override
    public void createDocumentGuardFor(GuardKeyType guardKeyType, KeyStoreAccess keyStoreAccess, DocumentKeyIDWithKey documentKeyIDWithKey, OverwriteFlag overwriteFlag) {
        LOGGER.debug("start create document guard for " + documentKeyIDWithKey + " at " + keyStoreAccess.getKeyStorePath());
        GuardKeyHelper helper = GuardKeyHelperFactory.getHelper(guardKeyType);
        KeySourceAndGuardKeyID keySourceAndGuardKeyID = helper.getKeySourceAndGuardKeyID(this.keystorePersistence, keyStoreAccess, documentKeyIDWithKey);
        this.createDocumentGuard(keyStoreAccess, documentKeyIDWithKey, keySourceAndGuardKeyID, overwriteFlag);
        LOGGER.debug("finished create document guard for " + documentKeyIDWithKey + " at " + keyStoreAccess.getKeyStorePath());
    }

    @Override
    public DocumentKeyIDWithKey loadDocumentKeyIDWithKeyFromDocumentGuard(KeyStoreAccess keyStoreAccess, DocumentKeyID documentKeyID) {
        LOGGER.debug("start load " + (Object)((Object)documentKeyID) + " from document guard at " + keyStoreAccess.getKeyStorePath());
        KeyStore userKeystore = this.keystorePersistence.loadKeystore(keyStoreAccess.getKeyStorePath().getObjectHandle(), keyStoreAccess.getKeyStoreAuth().getReadStoreHandler());
        KeyStoreBasedSecretKeySourceImpl keySource = new KeyStoreBasedSecretKeySourceImpl(userKeystore, keyStoreAccess.getKeyStoreAuth().getReadKeyHandler());
        BucketPath guardBucketPath = DocumentGuardLocation.getBucketPathOfGuard(keyStoreAccess.getKeyStorePath(), documentKeyID);
        if (!this.bucketService.fileExists(guardBucketPath)) {
            throw new NoDocumentGuardExists(guardBucketPath);
        }
        LOGGER.debug("loadDocumentKey for " + guardBucketPath);
        Payload payload = this.encryptedPersistenceUtil.loadAndDecrypt(guardBucketPath, (KeySource)keySource);
        String keyStoreTypeString = payload.getStorageMetadata().getUserMetadata().get(KEYSTORE_TYPE);
        if (keyStoreTypeString == null) {
            throw new BaseException("PROGRAMMING ERROR. KeyStoreType for Guard with KeyID " + (Object)((Object)documentKeyID) + " not known");
        }
        KeyStoreType keyStoreType = new KeyStoreType(keyStoreTypeString);
        String serializerId = payload.getStorageMetadata().getUserMetadata().get("serilizer_id");
        DocumentGuardSerializer serializer = this.serializerRegistry.getSerializer(serializerId);
        DocumentKey documentKey = serializer.deserializeSecretKey(payload.getData(), keyStoreType);
        LOGGER.debug("finished load " + (Object)((Object)documentKeyID) + " from document guard at " + keyStoreAccess.getKeyStorePath());
        DocumentKeyIDWithKey documentKeyIDWithKey = new DocumentKeyIDWithKey(documentKeyID, documentKey);
        return documentKeyIDWithKey;
    }

    private void createDocumentGuard(KeyStoreAccess keyStoreAccess, DocumentKeyIDWithKey documentKeyIDWithKey, KeySourceAndGuardKeyID keySourceAndGuardKeyID, OverwriteFlag overwriteFlag) {
        LOGGER.debug("start persist document guard for " + documentKeyIDWithKey + " at " + keyStoreAccess.getKeyStorePath());
        KeyStoreType keyStoreType = KeyStoreType.DEFAULT;
        BucketPath documentGuardBucketPath = DocumentGuardLocation.getBucketPathOfGuard(keyStoreAccess.getKeyStorePath(), documentKeyIDWithKey.getDocumentKeyID());
        if (overwriteFlag.equals((Object)OverwriteFlag.FALSE) && this.bucketService.fileExists(documentGuardBucketPath)) {
            throw new FileExistsException("File " + documentGuardBucketPath + " already exists and overwriteflag is false");
        }
        SimpleStorageMetadataImpl storageMetadata = new SimpleStorageMetadataImpl();
        DocumentGuardSerializer documentGuardSerializer = this.serializerRegistry.defaultSerializer();
        storageMetadata.getUserMetadata().put("serilizer_id", documentGuardSerializer.getSerializerID());
        storageMetadata.getUserMetadata().put(KEYSTORE_TYPE, keyStoreType.getValue());
        GuardKey guardKey = new GuardKey(documentGuardSerializer.serializeSecretKey(documentKeyIDWithKey.getDocumentKey(), keyStoreType));
        SimplePayloadImpl payload = new SimplePayloadImpl((StorageMetadata)storageMetadata, guardKey.getValue());
        this.encryptedPersistenceUtil.encryptAndPersist(documentGuardBucketPath, (Payload)payload, keySourceAndGuardKeyID.keySource, new KeyID(keySourceAndGuardKeyID.guardKeyID.getValue()));
        LOGGER.debug("finished persist document guard for " + documentKeyIDWithKey + " at " + keyStoreAccess.getKeyStorePath());
    }
}

