/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.service.impl;

import com.nimbusds.jose.jwk.JWK;
import org.adorsys.docusafe.service.KeySourceService;
import org.adorsys.encobject.domain.KeyStoreAccess;
import org.adorsys.encobject.service.api.ExtendedStoreConnection;
import org.adorsys.encobject.service.api.KeySource;
import org.adorsys.encobject.service.api.KeyStore2KeySourceHelper;
import org.adorsys.encobject.service.api.KeystorePersistence;
import org.adorsys.encobject.service.impl.BlobStoreKeystorePersistenceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeySourceServiceImpl
implements KeySourceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeySourceServiceImpl.class);
    private KeystorePersistence keystorePersistence;

    public KeySourceServiceImpl(ExtendedStoreConnection extendedStoreConnection) {
        this.keystorePersistence = new BlobStoreKeystorePersistenceImpl(extendedStoreConnection);
    }

    @Override
    public JWK findPublicEncryptionKey(KeyStoreAccess keyStoreAccess) {
        JWK publicKeyJWK = KeyStore2KeySourceHelper.getForPublicKeyJWK((KeystorePersistence)this.keystorePersistence, (KeyStoreAccess)keyStoreAccess);
        LOGGER.debug("Found public encryption key JWK :" + publicKeyJWK.getKeyID());
        return publicKeyJWK;
    }

    @Override
    public KeySource getPrivateKeySource(KeyStoreAccess keyStoreAccess) {
        return KeyStore2KeySourceHelper.getForPrivateKey((KeystorePersistence)this.keystorePersistence, (KeyStoreAccess)keyStoreAccess);
    }
}

