/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.service.types.complextypes;

import java.util.ArrayList;
import java.util.List;
import org.adorsys.docusafe.service.types.BucketContent;
import org.adorsys.encobject.complextypes.BucketDirectory;
import org.adorsys.encobject.complextypes.BucketPath;
import org.adorsys.encobject.domain.StorageMetadata;
import org.adorsys.encobject.domain.StorageType;

public class BucketContentImpl
implements BucketContent {
    private final BucketDirectory bucketDirectory;
    private final List<StorageMetadata> content;

    public BucketContentImpl(BucketDirectory bucketDirectory, List<StorageMetadata> content) {
        this.bucketDirectory = bucketDirectory;
        this.content = content;
    }

    @Override
    public BucketDirectory getBucketDirectory() {
        return this.bucketDirectory;
    }

    @Override
    public List<BucketPath> getFiles() {
        ArrayList<BucketPath> files = new ArrayList<BucketPath>();
        this.content.forEach(metadata -> {
            if (((StorageType)metadata.getType()).equals((Object)StorageType.BLOB)) {
                files.add(new BucketPath(metadata.getName()));
            }
        });
        return files;
    }

    @Override
    public List<BucketDirectory> getSubdirectories() {
        ArrayList<BucketDirectory> dirs = new ArrayList<BucketDirectory>();
        this.content.forEach(metadata -> {
            if (((StorageType)metadata.getType()).equals((Object)StorageType.FOLDER)) {
                dirs.add(new BucketDirectory(metadata.getName()));
            }
        });
        return dirs;
    }

    @Override
    public List<StorageMetadata> getContent() {
        return this.content;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("unstripped\n");
        sb.append("BucketContentImpl " + this.bucketDirectory + "(" + this.content.size() + "){");
        for (StorageMetadata meta : this.getContent()) {
            sb.append("\n\t[");
            sb.append(meta.getName());
            sb.append(" ");
            sb.append(meta.getType());
            sb.append(" ");
            sb.append(meta.getSize());
            sb.append("] ");
        }
        sb.append("}");
        return sb.toString();
    }
}

