/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.service.utils;

import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.crypto.SecretKey;
import javax.security.auth.callback.CallbackHandler;
import org.adorsys.cryptoutils.exceptions.BaseExceptionHandler;
import org.adorsys.jkeygen.keystore.KeyEntry;
import org.adorsys.jkeygen.keystore.KeyStoreService;
import org.adorsys.jkeygen.keystore.KeyStoreType;
import org.adorsys.jkeygen.keystore.KeystoreBuilder;
import org.adorsys.jkeygen.keystore.PasswordCallbackUtils;
import org.adorsys.jkeygen.keystore.SecretKeyData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeystoreAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeystoreAdapter.class);

    public static KeyStore wrapSecretKey2KeyStore(SecretKey secretKey, String alias, CallbackHandler keyPassHandler, KeyStoreType keyStoreType) {
        SecretKeyData secretKeyData = SecretKeyData.builder().secretKey(secretKey).alias(alias).passwordSource(keyPassHandler).build();
        try {
            return new KeystoreBuilder().withKeyEntry((KeyEntry)secretKeyData).withStoreType(keyStoreType).build();
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public static KeyStore loadKeystoreFromBytes(byte[] keyStoreDataBytes, CallbackHandler keystoreHandler, KeyStoreType keyStoreType) {
        try {
            String storeid = "if you can see this, its a programming error in KeyStoreAdapter";
            return KeyStoreService.loadKeyStore((byte[])keyStoreDataBytes, (String)storeid, (KeyStoreType)keyStoreType, (CallbackHandler)keystoreHandler);
        }
        catch (Exception ex) {
            throw BaseExceptionHandler.handle((Throwable)ex);
        }
    }

    public static Key readKeyFromKeystore(KeyStore keyStore, String keyID, CallbackHandler keyPassHandler) {
        try {
            return keyStore.getKey(keyID, PasswordCallbackUtils.getPassword((CallbackHandler)keyPassHandler, (String)keyID));
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public static byte[] toBytes(KeyStore keystore, String storeid, CallbackHandler storePassHandler) {
        try {
            byte[] bs = KeyStoreService.toByteArray((KeyStore)keystore, (String)storeid, (CallbackHandler)storePassHandler);
            return bs;
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }
}

