/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.service.keysource;

import java.security.Key;
import org.adorsys.cryptoutils.exceptions.BaseExceptionHandler;
import org.adorsys.docusafe.service.DocumentGuardService;
import org.adorsys.docusafe.service.impl.DocumentKeyID2DocumentKeyCache;
import org.adorsys.docusafe.service.types.DocumentKeyID;
import org.adorsys.docusafe.service.types.complextypes.DocumentKeyIDWithKeyAndAccessType;
import org.adorsys.encobject.domain.KeyStoreAccess;
import org.adorsys.encobject.service.api.KeySource;
import org.adorsys.encobject.types.KeyID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentGuardBasedKeySourceImpl
implements KeySource {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentGuardBasedKeySourceImpl.class);
    private DocumentGuardService documentGuardService;
    private DocumentKeyID2DocumentKeyCache documentKeyID2DocumentKeyCache;
    private KeyStoreAccess keyStoreAccess;

    public DocumentGuardBasedKeySourceImpl(DocumentGuardService documentGuardService, KeyStoreAccess keyStoreAccess, DocumentKeyID2DocumentKeyCache documentKeyID2DocumentKeyCache) {
        this.documentGuardService = documentGuardService;
        this.keyStoreAccess = keyStoreAccess;
        this.documentKeyID2DocumentKeyCache = documentKeyID2DocumentKeyCache;
    }

    public Key readKey(KeyID keyID) {
        try {
            DocumentKeyIDWithKeyAndAccessType fromCache;
            DocumentKeyID documentKeyID = new DocumentKeyID(keyID.getValue());
            if (this.documentKeyID2DocumentKeyCache != null && (fromCache = this.documentKeyID2DocumentKeyCache.get(this.keyStoreAccess, documentKeyID)) != null) {
                LOGGER.debug("return cached KEY WITH ID " + (Object)((Object)documentKeyID));
                return fromCache.getDocumentKeyIDWithKey().getDocumentKey().getSecretKey();
            }
            LOGGER.debug("try to load KEY WITH ID " + (Object)((Object)documentKeyID));
            DocumentKeyIDWithKeyAndAccessType documentKeyIDWithKeyAndAccessType = this.documentGuardService.loadDocumentKeyIDWithKeyAndAccessTypeFromDocumentGuard(this.keyStoreAccess, documentKeyID);
            LOGGER.debug("LOADED DOCUMENT KEY WITH ID " + documentKeyIDWithKeyAndAccessType);
            return documentKeyIDWithKeyAndAccessType.getDocumentKeyIDWithKey().getDocumentKey().getSecretKey();
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }
}

