/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.service.utils;

import java.security.KeyStore;
import java.util.Enumeration;
import java.util.HashMap;
import javax.crypto.spec.SecretKeySpec;
import org.adorsys.cryptoutils.exceptions.BaseExceptionHandler;
import org.adorsys.encobject.domain.ReadKeyPassword;
import org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPrivateCrtKey;

public class ShowKeyStore {
    public static String toString(KeyStore userKeyStore, ReadKeyPassword readKeyPassword) {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append("Number of Entries in KeyStore is:" + userKeyStore.size());
            sb.append("\n");
            Enumeration<String> aliases = userKeyStore.aliases();
            HashMap<String, Integer> classToInstances = new HashMap<String, Integer>();
            while (aliases.hasMoreElements()) {
                SecretKeySpec secretKeySpec;
                Object key;
                String alias = aliases.nextElement();
                try {
                    key = userKeyStore.getKey(alias, readKeyPassword.getValue().toCharArray());
                }
                catch (Exception e) {
                    key = userKeyStore.getKey(alias, "".toCharArray());
                }
                sb.append("alias : " + alias + " -> " + key.toString());
                sb.append("class      " + key.getClass().getSimpleName());
                sb.append("\n");
                String c = key.getClass().getSimpleName();
                classToInstances.put(c, classToInstances.get(c) != null ? (Integer)classToInstances.get(c) + 1 : 1);
                sb.append("Algorithm  " + key.getAlgorithm());
                sb.append("\n");
                sb.append("Format     " + key.getFormat());
                sb.append("\n");
                if (key instanceof SecretKeySpec) {
                    secretKeySpec = (SecretKeySpec)key;
                }
                if (key instanceof BCRSAPrivateCrtKey) {
                    secretKeySpec = (BCRSAPrivateCrtKey)key;
                }
                sb.append("\n");
            }
            for (Object key : classToInstances.keySet()) {
                sb.append((String)key + " -> " + classToInstances.get(key));
                sb.append("\n");
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }
}

