/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.service.serializer;

import java.security.KeyStore;
import javax.crypto.SecretKey;
import javax.security.auth.callback.CallbackHandler;
import org.adorsys.docusafe.service.serializer.DocumentGuardSerializer;
import org.adorsys.docusafe.service.types.DocumentKey;
import org.adorsys.docusafe.service.utils.KeystoreAdapter;
import org.adorsys.jkeygen.keystore.KeyStoreType;
import org.adorsys.jkeygen.pwd.PasswordCallbackHandler;

public class DocumentGuardSerializer01
implements DocumentGuardSerializer {
    public static final String SERIALIZER_ID = "dgs01";
    private static final String DGS01_KEYID = "keyid";
    private static CallbackHandler keystoreHandler = new PasswordCallbackHandler("just-to-have-a-not-null-callbackhandler".toCharArray());

    @Override
    public DocumentKey deserializeSecretKey(byte[] decryptedGuardBytes, KeyStoreType keyStoreType) {
        KeyStore secretKeystore = KeystoreAdapter.loadKeystoreFromBytes(decryptedGuardBytes, keystoreHandler, keyStoreType);
        SecretKey secretKey = (SecretKey)KeystoreAdapter.readKeyFromKeystore(secretKeystore, DGS01_KEYID, keystoreHandler);
        return new DocumentKey(secretKey);
    }

    @Override
    public byte[] serializeSecretKey(DocumentKey documentKey, KeyStoreType keyStoreType) {
        KeyStore docKeyStore = KeystoreAdapter.wrapSecretKey2KeyStore(documentKey.getSecretKey(), DGS01_KEYID, keystoreHandler, keyStoreType);
        return KeystoreAdapter.toBytes(docKeyStore, DGS01_KEYID, keystoreHandler);
    }

    @Override
    public String getSerializerID() {
        return SERIALIZER_ID;
    }
}

