/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.service.impl;

import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import org.adorsys.cryptoutils.exceptions.BaseException;
import org.adorsys.cryptoutils.utils.HexUtil;
import org.adorsys.encobject.service.api.EncryptionStreamService;
import org.adorsys.encobject.service.api.KeySource;
import org.adorsys.encobject.types.KeyID;

public class NoEncryptionStreamServiceImpl
implements EncryptionStreamService {
    public InputStream getEncryptedInputStream(InputStream inputStream, KeySource keySource, KeyID keyID, Boolean compress) {
        Key key = keySource.readKey(keyID);
        return new WriteKeyFirstInputStream(key, inputStream);
    }

    public InputStream getDecryptedInputStream(InputStream inputStream, KeySource keySource, KeyID keyID) {
        Key key = keySource.readKey(keyID);
        return new ReadKeyFirstInputStream(key, inputStream);
    }

    private static class ReadKeyFirstInputStream
    extends InputStream {
        private final InputStream origInputStream;
        private String keyString;
        private int keyStringLength;
        private int keyStringIndex = 0;
        private boolean keyRead = false;

        public ReadKeyFirstInputStream(Key key, InputStream origInputStream) {
            this.keyString = HexUtil.convertBytesToHexString((byte[])key.getEncoded());
            this.keyStringLength = this.keyString.length();
            this.keyStringIndex = 0;
            this.origInputStream = origInputStream;
        }

        @Override
        public int read() throws IOException {
            while (!this.keyRead) {
                char i2;
                char i1;
                if ((i1 = this.keyString.charAt(this.keyStringIndex++)) != (i2 = (char)this.origInputStream.read())) {
                    throw new BaseException("WRONG KEY. total length of key: " + this.keyStringLength + " wrong position:" + (this.keyStringIndex - 1));
                }
                if (this.keyStringIndex != this.keyStringLength) continue;
                this.keyRead = true;
            }
            return this.origInputStream.read();
        }
    }

    private static class WriteKeyFirstInputStream
    extends InputStream {
        private final InputStream origInputStream;
        private String keyString;
        private int keyStringLength;
        private int keyStringIndex;
        private boolean keyWritten = false;

        public WriteKeyFirstInputStream(Key key, InputStream origInputStream) {
            this.keyString = HexUtil.convertBytesToHexString((byte[])key.getEncoded());
            this.keyStringLength = this.keyString.length();
            this.keyStringIndex = 0;
            this.origInputStream = origInputStream;
        }

        @Override
        public int read() throws IOException {
            if (this.keyWritten) {
                return this.origInputStream.read();
            }
            char i = this.keyString.charAt(this.keyStringIndex++);
            if (this.keyStringIndex == this.keyStringLength) {
                this.keyWritten = true;
            }
            return i;
        }
    }
}

