/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.service.keysource;

import java.security.Key;
import org.adorsys.cryptoutils.exceptions.BaseExceptionHandler;
import org.adorsys.docusafe.service.DocumentGuardService;
import org.adorsys.docusafe.service.types.DocumentKeyID;
import org.adorsys.docusafe.service.types.complextypes.DocumentKeyIDWithKeyAndAccessType;
import org.adorsys.encobject.domain.KeyStoreAccess;
import org.adorsys.encobject.service.api.KeySource;
import org.adorsys.encobject.types.KeyID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentGuardBasedKeySourceImpl
implements KeySource {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentGuardBasedKeySourceImpl.class);
    private DocumentGuardService documentGuardService;
    private KeyStoreAccess keyStoreAccess;

    public DocumentGuardBasedKeySourceImpl(DocumentGuardService documentGuardService, KeyStoreAccess keyStoreAccess) {
        this.documentGuardService = documentGuardService;
        this.keyStoreAccess = keyStoreAccess;
    }

    public Key readKey(KeyID keyID) {
        try {
            DocumentKeyID documentKeyID = new DocumentKeyID(keyID.getValue());
            LOGGER.debug("try to load KEY WITH ID " + (Object)((Object)documentKeyID));
            DocumentKeyIDWithKeyAndAccessType documentKeyIDWithKeyAndAccessType = this.documentGuardService.loadDocumentKeyIDWithKeyAndAccessTypeFromDocumentGuard(this.keyStoreAccess, documentKeyID);
            LOGGER.debug("LOADED DOCUMENT KEY WITH ID " + documentKeyIDWithKeyAndAccessType);
            return documentKeyIDWithKeyAndAccessType.getDocumentKeyIDWithKey().getDocumentKey().getSecretKey();
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }
}

