/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.service.impl;

import org.adorsys.docusafe.service.DocumentGuardService;
import org.adorsys.docusafe.service.DocumentPersistenceService;
import org.adorsys.docusafe.service.impl.BucketServiceImpl;
import org.adorsys.docusafe.service.impl.DocumentGuardServiceImpl;
import org.adorsys.docusafe.service.impl.NoEncryptionStreamServiceImpl;
import org.adorsys.docusafe.service.keysource.DocumentGuardBasedKeySourceImpl;
import org.adorsys.docusafe.service.keysource.DocumentKeyIDWithKeyBasedSourceImpl;
import org.adorsys.docusafe.service.types.complextypes.DocumentBucketPath;
import org.adorsys.docusafe.service.types.complextypes.DocumentKeyIDWithKey;
import org.adorsys.encobject.complextypes.BucketPath;
import org.adorsys.encobject.domain.KeyStoreAccess;
import org.adorsys.encobject.domain.Payload;
import org.adorsys.encobject.domain.PayloadStream;
import org.adorsys.encobject.exceptions.FileExistsException;
import org.adorsys.encobject.service.api.ContainerPersistence;
import org.adorsys.encobject.service.api.EncryptedPersistenceService;
import org.adorsys.encobject.service.api.EncryptionStreamService;
import org.adorsys.encobject.service.api.ExtendedStoreConnection;
import org.adorsys.encobject.service.api.KeySource;
import org.adorsys.encobject.service.impl.AESEncryptionStreamServiceImpl;
import org.adorsys.encobject.service.impl.ContainerPersistenceImpl;
import org.adorsys.encobject.service.impl.EncryptedPersistenceServiceImpl;
import org.adorsys.encobject.types.KeyID;
import org.adorsys.encobject.types.OverwriteFlag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentPersistenceServiceImpl
implements DocumentPersistenceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentPersistenceServiceImpl.class);
    private EncryptedPersistenceService encryptedPersistenceService;
    private DocumentGuardService documentGuardService;
    private ContainerPersistence containerPersistence;
    private BucketServiceImpl bucketService;

    public DocumentPersistenceServiceImpl(ExtendedStoreConnection extendedStoreConnection) {
        this.containerPersistence = new ContainerPersistenceImpl(extendedStoreConnection);
        if (System.getProperty("UGLY_NO_ENCRYPTION") != null) {
            LOGGER.info("ACHTUNG, NO ENCRYPTION");
            this.encryptedPersistenceService = new EncryptedPersistenceServiceImpl(extendedStoreConnection, (EncryptionStreamService)new NoEncryptionStreamServiceImpl());
        } else {
            this.encryptedPersistenceService = new EncryptedPersistenceServiceImpl(extendedStoreConnection, (EncryptionStreamService)new AESEncryptionStreamServiceImpl());
        }
        this.documentGuardService = new DocumentGuardServiceImpl(extendedStoreConnection);
        this.bucketService = new BucketServiceImpl(extendedStoreConnection);
    }

    @Override
    public void persistDocument(DocumentKeyIDWithKey documentKeyIDWithKey, DocumentBucketPath documentBucketPath, OverwriteFlag overwriteFlag, Payload payload) {
        LOGGER.debug("start persist " + (Object)((Object)documentBucketPath));
        if (overwriteFlag.equals((Object)OverwriteFlag.FALSE) && this.bucketService.fileExists(documentBucketPath)) {
            throw new FileExistsException((Object)((Object)documentBucketPath) + " existiert und overwrite flag ist false");
        }
        DocumentKeyIDWithKeyBasedSourceImpl keySource = new DocumentKeyIDWithKeyBasedSourceImpl(documentKeyIDWithKey);
        LOGGER.debug("Document wird verschl\u00fcsselt mit " + documentKeyIDWithKey);
        KeyID keyID = new KeyID(documentKeyIDWithKey.getDocumentKeyID().getValue());
        this.encryptedPersistenceService.encryptAndPersist((BucketPath)documentBucketPath, payload, (KeySource)keySource, keyID);
        LOGGER.debug("finished persist " + (Object)((Object)documentBucketPath));
    }

    @Override
    public Payload loadDocument(KeyStoreAccess keyStoreAccess, DocumentBucketPath documentBucketPath) {
        LOGGER.debug("start load " + (Object)((Object)documentBucketPath) + " " + keyStoreAccess);
        DocumentGuardBasedKeySourceImpl keySource = new DocumentGuardBasedKeySourceImpl(this.documentGuardService, keyStoreAccess);
        Payload payload = this.encryptedPersistenceService.loadAndDecrypt((BucketPath)documentBucketPath, (KeySource)keySource);
        LOGGER.debug("finished load " + (Object)((Object)documentBucketPath));
        return payload;
    }

    @Override
    public void persistDocumentStream(DocumentKeyIDWithKey documentKeyIDWithKey, DocumentBucketPath documentBucketPath, OverwriteFlag overwriteFlag, PayloadStream payloadStream) {
        LOGGER.debug("start persist stream " + (Object)((Object)documentBucketPath));
        if (overwriteFlag.equals((Object)OverwriteFlag.FALSE) && this.bucketService.fileExists(documentBucketPath)) {
            throw new FileExistsException((Object)((Object)documentBucketPath) + " existiert und overwrite flag ist false");
        }
        DocumentKeyIDWithKeyBasedSourceImpl keySource = new DocumentKeyIDWithKeyBasedSourceImpl(documentKeyIDWithKey);
        LOGGER.debug("Document wird verschl\u00fcsselt mit " + documentKeyIDWithKey);
        KeyID keyID = new KeyID(documentKeyIDWithKey.getDocumentKeyID().getValue());
        this.encryptedPersistenceService.encryptAndPersistStream((BucketPath)documentBucketPath, payloadStream, (KeySource)keySource, keyID);
        LOGGER.debug("finished persist " + (Object)((Object)documentBucketPath));
    }

    @Override
    public PayloadStream loadDocumentStream(KeyStoreAccess keyStoreAccess, DocumentBucketPath documentBucketPath) {
        LOGGER.debug("start load stream " + (Object)((Object)documentBucketPath) + " " + keyStoreAccess);
        DocumentGuardBasedKeySourceImpl keySource = new DocumentGuardBasedKeySourceImpl(this.documentGuardService, keyStoreAccess);
        PayloadStream payloadStream = this.encryptedPersistenceService.loadAndDecryptStream((BucketPath)documentBucketPath, (KeySource)keySource);
        LOGGER.debug("finished load " + (Object)((Object)documentBucketPath));
        return payloadStream;
    }
}

