/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.service.impl.keystore.generator;

import javax.crypto.SecretKey;
import javax.security.auth.callback.CallbackHandler;
import org.adorsys.docusafe.service.api.keystore.types.SecretKeyGenerator;
import org.adorsys.docusafe.service.impl.keystore.generator.SecretKeyBuilder;
import org.adorsys.docusafe.service.impl.keystore.generator.SecretKeyData;

public class SecretKeyGeneratorImpl
implements SecretKeyGenerator {
    private final String secretKeyAlgo;
    private final Integer keySize;

    public SecretKeyGeneratorImpl(String secretKeyAlgo, Integer keySize) {
        this.secretKeyAlgo = secretKeyAlgo;
        this.keySize = keySize;
    }

    @Override
    public SecretKeyData generate(String alias, CallbackHandler secretKeyPassHandler) {
        SecretKey secretKey = new SecretKeyBuilder().withKeyAlg(this.secretKeyAlgo).withKeyLength(this.keySize).build();
        return SecretKeyData.builder().secretKey(secretKey).alias(alias).passwordSource(secretKeyPassHandler).keyAlgo(this.secretKeyAlgo).build();
    }
}

