/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.service.impl.keystore.generator;

import javax.crypto.SecretKey;
import javax.security.auth.callback.CallbackHandler;
import org.adorsys.docusafe.service.api.keystore.types.SecretKeyEntry;
import org.adorsys.docusafe.service.impl.keystore.generator.KeyEntryData;

public class SecretKeyData
extends KeyEntryData
implements SecretKeyEntry {
    private final SecretKey secretKey;
    private final String keyAlgo;

    private SecretKeyData(CallbackHandler passwordSource, String alias, SecretKey secretKey, String keyAlgo) {
        super(passwordSource, alias);
        this.secretKey = secretKey;
        this.keyAlgo = keyAlgo;
    }

    public static SecretKeyDataBuilder builder() {
        return new SecretKeyDataBuilder();
    }

    @Override
    public SecretKey getSecretKey() {
        return this.secretKey;
    }

    @Override
    public String getKeyAlgo() {
        return this.keyAlgo;
    }

    public static class SecretKeyDataBuilder {
        private CallbackHandler passwordSource;
        private String alias;
        private SecretKey secretKey;
        private String keyAlgo;

        SecretKeyDataBuilder() {
        }

        public SecretKeyDataBuilder passwordSource(CallbackHandler passwordSource) {
            this.passwordSource = passwordSource;
            return this;
        }

        public SecretKeyDataBuilder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public SecretKeyDataBuilder secretKey(SecretKey secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public SecretKeyDataBuilder keyAlgo(String keyAlgo) {
            this.keyAlgo = keyAlgo;
            return this;
        }

        public SecretKeyData build() {
            return new SecretKeyData(this.passwordSource, this.alias, this.secretKey, this.keyAlgo);
        }

        public String toString() {
            return "SecretKeyData.SecretKeyDataBuilder(passwordSource=" + this.passwordSource + ", alias=" + this.alias + ", secretKey=" + this.secretKey + ", keyAlgo=" + this.keyAlgo + ")";
        }
    }
}

