/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.service.impl.keystore.generator;

import java.io.IOException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;

public class PublicKeyUtils {
    public static PublicKey getPublicKey(X509CertificateHolder certificateHolder, Provider provider) throws InvalidKeySpecException {
        X509EncodedKeySpec x509EncodedKeySpec;
        if (certificateHolder == null) {
            return null;
        }
        SubjectPublicKeyInfo subjectPublicKeyInfo = certificateHolder.getSubjectPublicKeyInfo();
        try {
            x509EncodedKeySpec = new X509EncodedKeySpec(subjectPublicKeyInfo.getEncoded());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        try {
            return KeyFactory.getInstance(subjectPublicKeyInfo.getAlgorithm().getAlgorithm().getId(), provider).generatePublic(x509EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public static PublicKey getPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo, Provider provider) throws InvalidKeySpecException {
        X509EncodedKeySpec x509EncodedKeySpec;
        if (subjectPublicKeyInfo == null) {
            return null;
        }
        try {
            x509EncodedKeySpec = new X509EncodedKeySpec(subjectPublicKeyInfo.getEncoded());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        try {
            return KeyFactory.getInstance(subjectPublicKeyInfo.getAlgorithm().getAlgorithm().getId(), provider).generatePublic(x509EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public static PublicKey getPublicKeySilent(X509CertificateHolder certificateHolder, Provider provider) {
        X509EncodedKeySpec x509EncodedKeySpec;
        if (certificateHolder == null) {
            return null;
        }
        SubjectPublicKeyInfo subjectPublicKeyInfo = certificateHolder.getSubjectPublicKeyInfo();
        try {
            x509EncodedKeySpec = new X509EncodedKeySpec(subjectPublicKeyInfo.getEncoded());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        try {
            return KeyFactory.getInstance(subjectPublicKeyInfo.getAlgorithm().getAlgorithm().getId(), provider).generatePublic(x509EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalStateException(e);
        }
    }
}

