/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.service.impl.keystore.generator;

import de.adorsys.common.exceptions.BaseExceptionHandler;
import java.security.KeyStore;
import java.util.Date;
import java.util.UUID;
import org.adorsys.docusafe.service.api.keystore.exceptions.KeyStoreConfigException;
import org.adorsys.docusafe.service.api.keystore.types.KeyPairEntry;
import org.adorsys.docusafe.service.api.keystore.types.KeyStoreCreationConfig;
import org.adorsys.docusafe.service.api.keystore.types.KeyStoreType;
import org.adorsys.docusafe.service.api.keystore.types.ReadKeyPassword;
import org.adorsys.docusafe.service.api.keystore.types.SecretKeyEntry;
import org.adorsys.docusafe.service.impl.keystore.generator.KeyPairGeneratorImpl;
import org.adorsys.docusafe.service.impl.keystore.generator.KeyStoreCreationConfigImpl;
import org.adorsys.docusafe.service.impl.keystore.generator.KeystoreBuilder;
import org.adorsys.docusafe.service.impl.keystore.generator.PasswordCallbackHandler;
import org.adorsys.docusafe.service.impl.keystore.generator.SecretKeyGeneratorImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyStoreGenerator.class);
    private final KeyStoreType keyStoreType;
    private final String serverKeyPairAliasPrefix;
    private final KeyStoreCreationConfigImpl config;
    private final ReadKeyPassword readKeyPassword;

    public KeyStoreGenerator(KeyStoreCreationConfig config, KeyStoreType keyStoreType, String serverKeyPairAliasPrefix, ReadKeyPassword readKeyPassword) {
        this.config = new KeyStoreCreationConfigImpl(config);
        this.keyStoreType = keyStoreType;
        this.serverKeyPairAliasPrefix = "KEYSTORE-ID-0";
        this.readKeyPassword = readKeyPassword;
        LOGGER.debug("Keystore ID ignored " + serverKeyPairAliasPrefix);
    }

    public KeyStore generate() {
        if (this.config.getEncKeyNumber() == 0 && this.config.getSecretKeyNumber() == 0 && this.config.getSignKeyNumber() == 0) {
            throw new KeyStoreConfigException("Configuration of keystore must at least contain one key");
        }
        KeyStore keyStore = null;
        Date startTime = new Date();
        try {
            KeyPairEntry signatureKeyPair;
            int i;
            String keyStoreID = this.serverKeyPairAliasPrefix;
            PasswordCallbackHandler readKeyHandler = new PasswordCallbackHandler(this.readKeyPassword.getValue().toCharArray());
            KeystoreBuilder keystoreBuilder = new KeystoreBuilder().withStoreType(this.keyStoreType);
            KeyPairGeneratorImpl encKeyPairGenerator = this.config.getEncKeyPairGenerator(keyStoreID);
            int numberOfEncKeyPairs = this.config.getEncKeyNumber();
            for (i = 0; i < numberOfEncKeyPairs; ++i) {
                signatureKeyPair = encKeyPairGenerator.generateEncryptionKey(this.serverKeyPairAliasPrefix + UUID.randomUUID().toString(), readKeyHandler);
                keystoreBuilder = keystoreBuilder.withKeyEntry(signatureKeyPair);
            }
            KeyPairGeneratorImpl signKeyPairGenerator = this.config.getSignKeyPairGenerator(keyStoreID);
            int numberOfSignKeyPairs = this.config.getSignKeyNumber();
            for (i = 0; i < numberOfSignKeyPairs; ++i) {
                signatureKeyPair = signKeyPairGenerator.generateSignatureKey(this.serverKeyPairAliasPrefix + UUID.randomUUID().toString(), readKeyHandler);
                keystoreBuilder = keystoreBuilder.withKeyEntry(signatureKeyPair);
            }
            SecretKeyGeneratorImpl secretKeyGenerator = this.config.getSecretKeyGenerator(keyStoreID);
            int numberOfSecretKeys = this.config.getSecretKeyNumber();
            for (i = 0; i < numberOfSecretKeys; ++i) {
                SecretKeyEntry secretKeyData = secretKeyGenerator.generate(this.serverKeyPairAliasPrefix + UUID.randomUUID().toString(), readKeyHandler);
                keystoreBuilder = keystoreBuilder.withKeyEntry(secretKeyData);
            }
            KeyStore keyStore2 = keyStore = keystoreBuilder.build();
            return keyStore2;
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
        finally {
            Date stopTime = new Date();
            long duration = stopTime.getTime() - startTime.getTime();
            LOGGER.debug("KeyStoreGeneration (milliseconds) DURATION WAS " + duration);
        }
    }
}

