/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.service.impl.keystore.generator;

import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.adorsys.docusafe.service.impl.keystore.generator.BatchValidator;
import org.adorsys.docusafe.service.impl.keystore.generator.CheckCaCertificate;
import org.adorsys.docusafe.service.impl.keystore.generator.KeyUsageUtils;
import org.adorsys.docusafe.service.impl.keystore.generator.KeyValue;
import org.adorsys.docusafe.service.impl.keystore.generator.ListOfKeyValueBuilder;
import org.adorsys.docusafe.service.impl.keystore.generator.SerialNumberGenerator;
import org.adorsys.docusafe.service.impl.keystore.generator.V3CertificateUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;

public class CaSignedCertificateBuilder {
    private boolean createCaCert;
    private X500Name subjectDN;
    private boolean subjectOnlyInAlternativeName;
    private Integer notAfterInDays;
    private Integer notBeforeInDays = 0;
    private X509CertificateHolder subjectSampleCertificate;
    private X509CertificateHolder issuerCertificate;
    private int keyUsage = -1;
    private boolean keyUsageSet = false;
    private GeneralNames subjectAltNames;
    private AuthorityInformationAccess authorityInformationAccess;
    private String signatureAlgo;
    private PublicKey subjectPublicKey;
    boolean dirty = false;

    public X509CertificateHolder build(PrivateKey issuerPrivatekey) {
        List<KeyValue> notNullCheckList;
        List<String> errorKeys;
        Date notBefore;
        if (this.dirty) {
            throw new IllegalStateException("Builder can not be reused");
        }
        this.dirty = true;
        if (StringUtils.isBlank((CharSequence)this.signatureAlgo)) {
            String algorithm = issuerPrivatekey.getAlgorithm();
            if (StringUtils.equalsAnyIgnoreCase((CharSequence)"DSA", (CharSequence[])new CharSequence[]{algorithm})) {
                this.signatureAlgo = "SHA256withDSA";
            } else if (StringUtils.equals((CharSequence)"RSA", (CharSequence)algorithm)) {
                this.signatureAlgo = "SHA256WithRSA";
            }
        }
        Date now = new Date();
        Date notAfter = this.notAfterInDays != null ? DateUtils.addDays((Date)now, (int)this.notAfterInDays) : null;
        Date date = notBefore = this.notBeforeInDays != null ? DateUtils.addDays((Date)now, (int)this.notBeforeInDays) : null;
        if (this.subjectSampleCertificate != null) {
            Extension extension;
            this.subjectPublicKey = V3CertificateUtils.extractPublicKey(this.subjectSampleCertificate);
            if (this.subjectDN == null) {
                this.subjectDN = this.subjectSampleCertificate.getSubject();
            }
            if (notAfter == null) {
                notAfter = this.subjectSampleCertificate.getNotAfter();
            }
            if (notBefore == null) {
                notBefore = this.subjectSampleCertificate.getNotBefore();
            }
            if (!this.keyUsageSet) {
                this.copyKeyUsage(this.subjectSampleCertificate);
            }
            if (this.subjectAltNames == null && (extension = this.subjectSampleCertificate.getExtension(X509Extension.subjectAlternativeName)) != null) {
                this.subjectAltNames = GeneralNames.getInstance((Object)extension.getParsedValue());
            }
        }
        if ((errorKeys = BatchValidator.filterNull(notNullCheckList = ListOfKeyValueBuilder.newBuilder().add("X509CertificateBuilder_missing_subject_DN", this.subjectDN).add("X509CertificateBuilder_missing_subject_publicKey", this.subjectPublicKey).add("X509CertificateBuilder_missing_validity_date_notBefore", notBefore).add("X509CertificateBuilder_missing_validity_date_notAfter", notAfter).build())) == null) {
            errorKeys = new ArrayList<String>();
        }
        X500Name issuerDN = null;
        BasicConstraints basicConstraints = null;
        if (this.issuerCertificate == null) {
            issuerDN = this.subjectDN;
            if (this.createCaCert) {
                basicConstraints = new BasicConstraints(true);
                this.subjectOnlyInAlternativeName = false;
            } else {
                basicConstraints = new BasicConstraints(false);
            }
        } else {
            if (!CheckCaCertificate.isCaCertificate(this.issuerCertificate)) {
                errorKeys.add("X509CertificateBuilder_issuerCert_notCaCert");
            }
            issuerDN = this.issuerCertificate.getSubject();
            if (this.createCaCert) {
                this.subjectOnlyInAlternativeName = false;
                Extension basicConstraintsExtension = this.issuerCertificate.getExtension(X509Extension.basicConstraints);
                BasicConstraints issuerBasicConstraints = BasicConstraints.getInstance((Object)basicConstraintsExtension.getParsedValue());
                BigInteger pathLenConstraint = issuerBasicConstraints.getPathLenConstraint();
                pathLenConstraint = pathLenConstraint == null ? BigInteger.ONE : pathLenConstraint.add(BigInteger.ONE);
                basicConstraints = new BasicConstraints(pathLenConstraint.intValue());
                this.resetKeyUsage();
                for (int keyUsage : KeyUsageUtils.getCaKeyUsages()) {
                    this.withKeyUsage(keyUsage);
                }
            } else {
                basicConstraints = new BasicConstraints(false);
            }
        }
        BigInteger serial = SerialNumberGenerator.uniqueSerial();
        JcaX509v3CertificateBuilder v3CertGen = null;
        if (this.subjectOnlyInAlternativeName && this.subjectAltNames != null) {
            errorKeys.remove("X509CertificateBuilder_missing_subject_DN");
            this.subjectDN = new X500Name("cn=");
        }
        if (!errorKeys.isEmpty()) {
            throw new IllegalArgumentException("Fields can not be null: " + errorKeys);
        }
        v3CertGen = new JcaX509v3CertificateBuilder(issuerDN, serial, notBefore, notAfter, this.subjectDN, this.subjectPublicKey);
        JcaX509ExtensionUtils extUtils = V3CertificateUtils.getJcaX509ExtensionUtils();
        try {
            v3CertGen.addExtension(X509Extension.basicConstraints, true, (ASN1Encodable)basicConstraints);
            v3CertGen.addExtension(X509Extension.subjectKeyIdentifier, false, (ASN1Encodable)extUtils.createSubjectKeyIdentifier(this.subjectPublicKey));
            if (this.issuerCertificate == null) {
                v3CertGen.addExtension(X509Extension.authorityKeyIdentifier, false, (ASN1Encodable)extUtils.createAuthorityKeyIdentifier(this.subjectPublicKey));
            } else {
                v3CertGen.addExtension(X509Extension.authorityKeyIdentifier, false, (ASN1Encodable)extUtils.createAuthorityKeyIdentifier(this.issuerCertificate));
            }
            if (this.keyUsageSet) {
                v3CertGen.addExtension(X509Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(this.keyUsage));
            }
            if (this.subjectAltNames != null) {
                if (this.subjectOnlyInAlternativeName) {
                    v3CertGen.addExtension(X509Extension.subjectAlternativeName, true, (ASN1Encodable)this.subjectAltNames);
                } else {
                    v3CertGen.addExtension(X509Extension.subjectAlternativeName, false, (ASN1Encodable)this.subjectAltNames);
                }
            }
            if (this.authorityInformationAccess != null) {
                v3CertGen.addExtension(X509Extension.authorityInfoAccess, false, (ASN1Encodable)this.authorityInformationAccess);
            }
        }
        catch (CertIOException e) {
            throw new IllegalStateException(e);
        }
        ContentSigner signer = V3CertificateUtils.getContentSigner(issuerPrivatekey, this.signatureAlgo);
        return v3CertGen.build(signer);
    }

    private void copyKeyUsage(X509CertificateHolder issuerCertificate) {
        int ku = KeyUsageUtils.getKeyUsage(issuerCertificate);
        if (ku != -1) {
            this.withKeyUsage(ku);
        }
    }

    public CaSignedCertificateBuilder withSignatureAlgo(String signatureAlgo) {
        this.signatureAlgo = signatureAlgo;
        return this;
    }

    public CaSignedCertificateBuilder withCa(boolean ca) {
        this.createCaCert = ca;
        return this;
    }

    public CaSignedCertificateBuilder withSubjectDN(X500Name subjectDN) {
        this.subjectDN = subjectDN;
        return this;
    }

    public CaSignedCertificateBuilder withSubjectPublicKey(PublicKey subjectPublicKey) {
        this.subjectPublicKey = subjectPublicKey;
        return this;
    }

    public CaSignedCertificateBuilder withNotAfterInDays(Integer notAfterInDays) {
        this.notAfterInDays = notAfterInDays;
        return this;
    }

    public CaSignedCertificateBuilder withNotBeforeInDays(Integer notBeforeInDays) {
        this.notBeforeInDays = notBeforeInDays;
        return this;
    }

    public CaSignedCertificateBuilder withSubjectSampleCertificate(X509CertificateHolder subjectSampleCertificate) {
        this.subjectSampleCertificate = subjectSampleCertificate;
        return this;
    }

    public CaSignedCertificateBuilder withIssuerCertificate(X509CertificateHolder issuerCertificate) {
        if (!CheckCaCertificate.isCaCertificate(issuerCertificate)) {
            throw new IllegalArgumentException("Invalid issuer certificate");
        }
        this.issuerCertificate = issuerCertificate;
        return this;
    }

    public CaSignedCertificateBuilder resetKeyUsage() {
        this.keyUsageSet = false;
        this.keyUsage = -1;
        return this;
    }

    public CaSignedCertificateBuilder withKeyUsage(int keyUsage) {
        if (this.keyUsageSet) {
            this.keyUsage |= keyUsage;
        } else {
            this.keyUsage = keyUsage;
            this.keyUsageSet = true;
        }
        return this;
    }

    public CaSignedCertificateBuilder withSubjectAltNames(GeneralNames subjectAltNames) {
        if (this.subjectAltNames == null) {
            this.subjectAltNames = new GeneralNames(subjectAltNames.getNames());
        } else {
            GeneralName[] names2;
            GeneralName[] names1;
            ArrayList<GeneralName> nameList = new ArrayList<GeneralName>();
            for (GeneralName generalName : names1 = this.subjectAltNames.getNames()) {
                if (nameList.contains(generalName)) continue;
                nameList.add(generalName);
            }
            for (GeneralName generalName : names2 = subjectAltNames.getNames()) {
                if (nameList.contains(generalName)) continue;
                nameList.add(generalName);
            }
            GeneralName[] names = nameList.toArray(new GeneralName[nameList.size()]);
            this.subjectAltNames = new GeneralNames(names);
        }
        return this;
    }

    public CaSignedCertificateBuilder withSubjectAltName(GeneralName subjectAltName) {
        if (this.subjectAltNames == null) {
            this.subjectAltNames = new GeneralNames(subjectAltName);
        } else {
            GeneralName[] names1;
            ArrayList<GeneralName> nameList = new ArrayList<GeneralName>();
            for (GeneralName generalName : names1 = this.subjectAltNames.getNames()) {
                if (nameList.contains(generalName)) continue;
                nameList.add(generalName);
            }
            nameList.add(subjectAltName);
            GeneralName[] names = nameList.toArray(new GeneralName[nameList.size()]);
            this.subjectAltNames = new GeneralNames(names);
        }
        return this;
    }

    public CaSignedCertificateBuilder withAuthorityInformationAccess(AuthorityInformationAccess authorityInformationAccess) {
        this.authorityInformationAccess = authorityInformationAccess;
        return this;
    }

    public CaSignedCertificateBuilder withSubjectOnlyInAlternativeName(boolean subjectOnlyInAlternativeName) {
        this.subjectOnlyInAlternativeName = subjectOnlyInAlternativeName;
        return this;
    }
}

