/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.service.impl.bucketpathencryption;

import de.adorsys.common.exceptions.BaseExceptionHandler;
import de.adorsys.common.utils.HexUtil;
import de.adorsys.dfs.connection.api.complextypes.BucketDirectory;
import de.adorsys.dfs.connection.api.complextypes.BucketPath;
import de.adorsys.dfs.connection.api.complextypes.BucketPathUtil;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.adorsys.docusafe.service.api.bucketpathencryption.BucketPathEncryptionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BucketPathEncryptionServiceImpl
implements BucketPathEncryptionService {
    private static final Logger log = LoggerFactory.getLogger(BucketPathEncryptionServiceImpl.class);
    public static final String NO_BUCKETPATH_ENCRYPTION = "SC-NO-BUCKETPATH-ENCRYPTION";
    private static boolean active = BucketPathEncryptionServiceImpl.isActive();

    @Override
    public BucketPath encrypt(SecretKey secretKey, BucketPath bucketPath) {
        if (!active) {
            return bucketPath;
        }
        Cipher cipher = BucketPathEncryptionServiceImpl.createCipher(secretKey, 1);
        List elements = BucketPathUtil.split((String)BucketPathUtil.getAsString((BucketPath)bucketPath));
        return new BucketPath(this.encryptStringList(elements, cipher).toLowerCase());
    }

    @Override
    public BucketPath decrypt(SecretKey secretKey, BucketPath bucketPath) {
        if (!active) {
            return bucketPath;
        }
        Cipher cipher = BucketPathEncryptionServiceImpl.createCipher(secretKey, 2);
        List elements = BucketPathUtil.split((String)BucketPathUtil.getAsString((BucketPath)bucketPath));
        return new BucketPath(this.decryptStringList(elements, cipher));
    }

    @Override
    public BucketDirectory encrypt(SecretKey secretKey, BucketDirectory bucketDirectory) {
        if (!active) {
            return bucketDirectory;
        }
        Cipher cipher = BucketPathEncryptionServiceImpl.createCipher(secretKey, 1);
        List elements = BucketPathUtil.split((String)BucketPathUtil.getAsString((BucketDirectory)bucketDirectory));
        return new BucketDirectory(this.encryptStringList(elements, cipher).toLowerCase());
    }

    @Override
    public BucketDirectory decrypt(SecretKey secretKey, BucketDirectory bucketDirectory) {
        if (!active) {
            return bucketDirectory;
        }
        Cipher cipher = BucketPathEncryptionServiceImpl.createCipher(secretKey, 2);
        List elements = BucketPathUtil.split((String)BucketPathUtil.getAsString((BucketDirectory)bucketDirectory));
        return new BucketDirectory(this.decryptStringList(elements, cipher));
    }

    private static Cipher createCipher(SecretKey secretKey, int cipherMode) {
        try {
            byte[] key = secretKey.getEncoded();
            MessageDigest sha = MessageDigest.getInstance("SHA-256");
            key = sha.digest(key);
            key = Arrays.copyOf(key, 16);
            SecretKeySpec secretKeySpec = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(cipherMode, secretKeySpec);
            return cipher;
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    private String encryptStringList(List<String> elements, Cipher cipher) {
        String first = elements.remove(0);
        StringBuilder encryptedPathString = new StringBuilder();
        for (String subdir : elements) {
            byte[] encrypt = new byte[]{};
            try {
                encrypt = cipher.doFinal(subdir.getBytes(StandardCharsets.UTF_8));
            }
            catch (BadPaddingException | IllegalBlockSizeException e) {
                e.printStackTrace();
            }
            String encryptedString = HexUtil.convertBytesToHexString((byte[])encrypt);
            encryptedPathString.append("/").append(encryptedString);
        }
        return first + "/" + encryptedPathString.toString();
    }

    private String decryptStringList(List<String> elements, Cipher cipher) {
        String first = elements.remove(0);
        StringBuilder decryptedPathString = new StringBuilder();
        for (String subdir : elements) {
            byte[] decrypt = HexUtil.convertHexStringToBytes((String)subdir.toUpperCase());
            byte[] decryptedBytes = new byte[]{};
            try {
                decryptedBytes = cipher.doFinal(decrypt);
            }
            catch (BadPaddingException | IllegalBlockSizeException e) {
                e.printStackTrace();
            }
            decryptedPathString.append("/").append(new String(decryptedBytes, StandardCharsets.UTF_8));
        }
        return first + "/" + decryptedPathString.toString();
    }

    private static boolean isActive() {
        if (System.getProperty(NO_BUCKETPATH_ENCRYPTION) != null) {
            log.info("encryption is off");
            return false;
        }
        log.info("encryption is on");
        return true;
    }
}

