/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.rest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import org.adorsys.docusafe.business.types.UserID;
import org.adorsys.docusafe.business.types.complex.DocumentDirectoryFQN;
import org.adorsys.docusafe.business.types.complex.DocumentFQN;
import org.adorsys.docusafe.rest.adapter.AccessTypeJsonAdapter;
import org.adorsys.docusafe.rest.adapter.BucketNameJsonAdapter;
import org.adorsys.docusafe.rest.adapter.DocumentContentJsonAdapter;
import org.adorsys.docusafe.rest.adapter.DocumentDirectoryFQNJsonAdapter;
import org.adorsys.docusafe.rest.adapter.DocumentFQNJsonAdapter;
import org.adorsys.docusafe.rest.adapter.DocumentKeyIDJsonAdapter;
import org.adorsys.docusafe.rest.adapter.ReadKeyPasswordJsonAdapter;
import org.adorsys.docusafe.rest.adapter.SpringfoxJsonToGsonAdapter;
import org.adorsys.docusafe.rest.adapter.UserIDJsonAdapter;
import org.adorsys.docusafe.service.types.AccessType;
import org.adorsys.docusafe.service.types.DocumentContent;
import org.adorsys.docusafe.service.types.DocumentKeyID;
import org.adorsys.encobject.domain.ReadKeyPassword;
import org.adorsys.encobject.types.BucketName;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.GsonHttpMessageConverter;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import springfox.documentation.spring.web.json.Json;

@SpringBootApplication(exclude={JacksonAutoConfiguration.class, MongoAutoConfiguration.class})
@Configuration
@EnableWebMvc
public class WebMvcConfig
implements WebMvcConfigurer {
    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.add((HttpMessageConverter<?>)this.createGsonHttpMessageConverter());
        RestTemplate r = new RestTemplate();
        r.setMessageConverters(converters);
    }

    private GsonHttpMessageConverter createGsonHttpMessageConverter() {
        Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(BucketName.class, (Object)new BucketNameJsonAdapter()).registerTypeAdapter(DocumentKeyID.class, (Object)new DocumentKeyIDJsonAdapter()).registerTypeAdapter(UserID.class, (Object)new UserIDJsonAdapter()).registerTypeAdapter(ReadKeyPassword.class, (Object)new ReadKeyPasswordJsonAdapter()).registerTypeAdapter(DocumentFQN.class, (Object)new DocumentFQNJsonAdapter()).registerTypeAdapter(AccessType.class, (Object)new AccessTypeJsonAdapter()).registerTypeAdapter(DocumentDirectoryFQN.class, (Object)new DocumentDirectoryFQNJsonAdapter()).registerTypeAdapter(DocumentContent.class, (Object)new DocumentContentJsonAdapter()).registerTypeAdapter(Json.class, (Object)new SpringfoxJsonToGsonAdapter()).create();
        GsonHttpMessageConverter gsonConverter = new GsonHttpMessageConverter();
        gsonConverter.setGson(gson);
        return gsonConverter;
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"swagger-ui.html"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/"});
        registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"});
    }
}

