/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.rest;

import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.adorsys.cryptoutils.exceptions.BaseExceptionHandler;
import org.adorsys.cryptoutils.storeconnectionfactory.ExtendedStoreConnectionFactory;
import org.adorsys.docusafe.business.DocumentSafeService;
import org.adorsys.docusafe.business.impl.DocumentSafeServiceImpl;
import org.adorsys.docusafe.business.types.UserID;
import org.adorsys.docusafe.business.types.complex.DSDocument;
import org.adorsys.docusafe.business.types.complex.DSDocumentStream;
import org.adorsys.docusafe.business.types.complex.DocumentDirectoryFQN;
import org.adorsys.docusafe.business.types.complex.DocumentFQN;
import org.adorsys.docusafe.business.types.complex.UserIDAuth;
import org.adorsys.docusafe.rest.types.GrantDocument;
import org.adorsys.encobject.domain.ReadKeyPassword;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.HandlerMapping;

@RestController
public class DocumentSafeController {
    private static final String APPLICATION_JSON = "application/json";
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentSafeController.class);
    private DocumentSafeService service = new DocumentSafeServiceImpl(ExtendedStoreConnectionFactory.get());

    @RequestMapping(value={"/internal/user"}, method={RequestMethod.PUT}, consumes={"application/json"}, produces={"application/json"})
    public void createUser(@RequestBody UserIDAuth userIDAuth) {
        this.service.createUser(userIDAuth);
    }

    @RequestMapping(value={"/internal/user"}, method={RequestMethod.DELETE}, consumes={"application/json"}, produces={"application/json"})
    public void destroyUser(@RequestBody UserIDAuth userIDAuth) {
        this.service.destroyUser(userIDAuth);
    }

    @RequestMapping(value={"/internal/user/{UserID}"}, method={RequestMethod.GET}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<Boolean> userExists(@PathVariable(value="UserID") String userIDString) {
        UserID userID = new UserID(userIDString);
        LOGGER.debug("get user exists: " + userID);
        if (!this.service.userExists(userID)) {
            LOGGER.debug(userID + " does not exist");
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        LOGGER.debug(userID + " exists");
        return new ResponseEntity((Object)Boolean.TRUE, HttpStatus.OK);
    }

    @RequestMapping(value={"/document"}, method={RequestMethod.PUT}, consumes={"application/json"})
    public void storeDocument(@RequestHeader(value="userid") String userid, @RequestHeader(value="password") String password, @RequestBody DSDocument dsDocument) {
        UserIDAuth userIDAuth = new UserIDAuth(new UserID(userid), new ReadKeyPassword(password));
        this.service.storeDocument(userIDAuth, dsDocument);
    }

    @RequestMapping(value={"/document/**"}, method={RequestMethod.GET}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<DSDocument> readDocument(@RequestHeader(value="userid") String userid, @RequestHeader(value="password") String password, HttpServletRequest request) {
        LOGGER.debug("get document request arrived");
        UserIDAuth userIDAuth = new UserIDAuth(new UserID(userid), new ReadKeyPassword(password));
        DocumentFQN documentFQN = new DocumentFQN(this.getFQN(request));
        if (!this.service.documentExists(userIDAuth, documentFQN)) {
            LOGGER.debug("document " + documentFQN + " does not exist");
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        LOGGER.debug("document " + documentFQN + " exists");
        return new ResponseEntity((Object)this.service.readDocument(userIDAuth, documentFQN), HttpStatus.OK);
    }

    @RequestMapping(value={"/documentstream"}, method={RequestMethod.PUT}, consumes={"application/octet-stream"})
    public void storeDocumentStream(@RequestHeader(value="userid") String userid, @RequestHeader(value="password") String password, @RequestHeader(value="documentFQN") String documentFQNString, InputStream inputStream) {
        UserIDAuth userIDAuth = new UserIDAuth(new UserID(userid), new ReadKeyPassword(password));
        DocumentFQN documentFQN = new DocumentFQN(documentFQNString);
        LOGGER.debug("input auf document/stream for " + userIDAuth);
        this.service.storeDocumentStream(userIDAuth, new DSDocumentStream(documentFQN, inputStream));
    }

    @RequestMapping(value={"/documentstream/**"}, method={RequestMethod.GET}, produces={"application/octet-stream"})
    public ResponseEntity readDocumentStream(@RequestHeader(value="userid") String userid, @RequestHeader(value="password") String password, HttpServletRequest request, HttpServletResponse response) {
        try {
            LOGGER.debug("get stream request arrived1");
            UserIDAuth userIDAuth = new UserIDAuth(new UserID(userid), new ReadKeyPassword(password));
            DocumentFQN documentFQN = new DocumentFQN(this.getFQN(request));
            LOGGER.debug("received:" + userIDAuth + " and " + documentFQN);
            if (!this.service.documentExists(userIDAuth, documentFQN)) {
                LOGGER.debug("documentstream " + documentFQN + " does not exist");
                return new ResponseEntity(HttpStatus.NOT_FOUND);
            }
            DSDocumentStream stream = this.service.readDocumentStream(userIDAuth, documentFQN);
            InputStream is = stream.getDocumentStream();
            ServletOutputStream os = response.getOutputStream();
            LOGGER.debug("start copy imputstream to outputstream");
            IOUtils.copy((InputStream)is, (OutputStream)os);
            LOGGER.debug("finished copy imputstream to outputstream");
            IOUtils.closeQuietly((InputStream)is);
            IOUtils.closeQuietly((OutputStream)os);
            LOGGER.debug("return outputstream to sender");
            return new ResponseEntity(HttpStatus.OK);
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    @RequestMapping(value={"/document/**"}, method={RequestMethod.DELETE}, consumes={"application/json"}, produces={"application/json"})
    public void destroyDocument(@RequestHeader(value="userid") String userid, @RequestHeader(value="password") String password, HttpServletRequest request) {
        LOGGER.debug("destroy document request arrived");
        UserIDAuth userIDAuth = new UserIDAuth(new UserID(userid), new ReadKeyPassword(password));
        DocumentFQN documentFQN = new DocumentFQN(this.getFQN(request));
        if (documentFQN.getValue().endsWith("/")) {
            DocumentDirectoryFQN documentDirectoryFQN = new DocumentDirectoryFQN(documentFQN.getValue());
            LOGGER.debug("destroy document folder " + documentDirectoryFQN);
            this.service.deleteFolder(userIDAuth, documentDirectoryFQN);
        } else {
            this.service.deleteDocument(userIDAuth, documentFQN);
        }
        LOGGER.debug("destroy document request finished");
    }

    @RequestMapping(value={"/grant/document"}, method={RequestMethod.PUT}, consumes={"application/json"}, produces={"application/json"})
    public void grantAccess(@RequestHeader(value="userid") String userid, @RequestHeader(value="password") String password, @RequestBody GrantDocument grantDocument) {
        UserIDAuth userIDAuth = new UserIDAuth(new UserID(userid), new ReadKeyPassword(password));
        this.service.grantAccessToUserForFolder(userIDAuth, grantDocument.getReceivingUser(), grantDocument.getDocumentDirectoryFQN(), grantDocument.getAccessType());
    }

    @RequestMapping(value={"/granted/document/{ownerUserID}"}, method={RequestMethod.PUT}, consumes={"application/json"}, produces={"application/json"})
    public void storeGrantedDocument(@RequestHeader(value="userid") String userid, @RequestHeader(value="password") String password, @PathVariable(value="ownerUserID") String ownerUserIDString, @RequestBody DSDocument dsDocument) {
        UserID ownerUserID = new UserID(ownerUserIDString);
        UserIDAuth userIDAuth = new UserIDAuth(new UserID(userid), new ReadKeyPassword(password));
        this.service.storeGrantedDocument(userIDAuth, ownerUserID, dsDocument);
    }

    @RequestMapping(value={"/granted/document/{ownerUserID}/**"}, method={RequestMethod.GET}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public DSDocument readGrantedDocument(@RequestHeader(value="userid") String userid, @RequestHeader(value="password") String password, @PathVariable(value="ownerUserID") String ownerUserIDString, HttpServletRequest request) {
        UserIDAuth userIDAuth = new UserIDAuth(new UserID(userid), new ReadKeyPassword(password));
        UserID ownerUserID = new UserID(ownerUserIDString);
        String documentFQNString = this.getFQN(request);
        DocumentFQN documentFQN = new DocumentFQN(documentFQNString);
        LOGGER.debug("received:" + userIDAuth + " and " + ownerUserID + " and " + documentFQN);
        return this.service.readGrantedDocument(userIDAuth, ownerUserID, documentFQN);
    }

    private String getFQN(HttpServletRequest request) {
        String path = request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE).toString();
        String bestMatchingPattern = request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE).toString();
        String documentFQNStringWithQuotes = new AntPathMatcher().extractPathWithinPattern(bestMatchingPattern, path);
        return documentFQNStringWithQuotes.replaceAll("\"", "");
    }
}

