/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.client;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.adorsys.cryptoutils.exceptions.BaseExceptionHandler;
import org.adorsys.cryptoutils.utils.HexUtil;
import org.adorsys.docusafe.client.api.CreateUserRequest;
import org.adorsys.docusafe.client.api.DSDocument;
import org.adorsys.docusafe.client.api.ReadDocumentResponse;
import org.adorsys.docusafe.client.api.WriteDocumentRequest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.glassfish.jersey.client.ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentsafeRestClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentsafeRestClient.class);
    public static final int CHUNKSIZE = 1024;
    public static final String DOCUMENT_FQN = "documentFQN";
    private String baseuri;
    private Client client;
    private static final String CREATE_USER = "internal/user";
    private static final String READ_DOCUMENT = "document";
    private static final String READ_DOCUMENT_STREAM = "documentstream";
    private static final String PASSWORD = "password";
    private static final String USER_ID = "userID";
    private static final String WRITE_DOCUMENT = "document";
    private static final String WRITE_DOCUMENT_STREAM1 = "documentstream";

    public DocumentsafeRestClient(String baseuri) {
        this.baseuri = baseuri;
        this.client = ClientBuilder.newClient((Configuration)new ClientConfig().property("javax.json.stream.JsonGenerator.prettyPrinting", (Object)true).property("jersey.config.client.request.entity.processing", (Object)"CHUNKED").property("jersey.config.client.chunkedEncodingSize", (Object)1024));
    }

    public void createUser(String userID, String password) {
        CreateUserRequest createUserRequest = new CreateUserRequest(userID, password);
        Response response = this.client.target(this.baseuri).path(CREATE_USER).request().put(Entity.entity((Object)createUserRequest, (MediaType)MediaType.APPLICATION_JSON_TYPE));
        LOGGER.debug("User " + userID + "created: " + response.getStatus());
    }

    public void readDocument(String userID, String password, String fqn, String filenameToSave) {
        LOGGER.debug("lese nun bytes f\u00fcr " + fqn);
        try {
            ReadDocumentResponse readDocument = (ReadDocumentResponse)this.client.target(this.baseuri).path("document").path("\"" + fqn + "\"").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header(USER_ID, (Object)userID).header(PASSWORD, (Object)password).header("Content-Type", (Object)"application/json").get(ReadDocumentResponse.class);
            FileUtils.writeByteArrayToFile((File)new File(filenameToSave), (byte[])HexUtil.convertHexStringToBytes((String)readDocument.getDocumentContent()));
        }
        catch (IOException e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public void readDocumentStream(String userID, String password, String fqn, String filenameToSave) {
        LOGGER.debug("lese nun stream f\u00fcr " + fqn);
        try {
            InputStream inputStream = (InputStream)this.client.target(this.baseuri).path("documentstream").path("\"" + fqn + "\"").request(new MediaType[]{MediaType.APPLICATION_OCTET_STREAM_TYPE}).header(USER_ID, (Object)userID).header(PASSWORD, (Object)password).get(InputStream.class);
            FileOutputStream fos = new FileOutputStream(filenameToSave);
            LOGGER.debug("start writing file " + filenameToSave);
            IOUtils.copy((InputStream)inputStream, (OutputStream)fos);
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((OutputStream)fos);
            LOGGER.debug("finished writing file " + filenameToSave);
        }
        catch (IOException e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public void writeDocumentStream(String userID, String password, String fqn, InputStream in, long size) {
        LOGGER.debug("verschicke nun " + size + " bytes");
        String contentDisposition = "attachment; filename=\"" + fqn + "\"";
        Response response = this.client.target(this.baseuri).path("documentstream").request(new MediaType[]{MediaType.APPLICATION_OCTET_STREAM_TYPE}).header("Content-Disposition", (Object)contentDisposition).header(USER_ID, (Object)userID).header(PASSWORD, (Object)password).header(DOCUMENT_FQN, (Object)fqn).put(Entity.entity((Object)in, (MediaType)MediaType.APPLICATION_OCTET_STREAM_TYPE));
    }

    public void writeDocument(String userID, String password, String fqn, byte[] data) {
        WriteDocumentRequest writeDocumentRequest = new WriteDocumentRequest();
        writeDocumentRequest.setDocumentFQN(fqn);
        writeDocumentRequest.setDocumentContent(HexUtil.convertBytesToHexString((byte[])data));
        DSDocument.DocumentMetaInfo documentMetaInfo = new DSDocument.DocumentMetaInfo();
        writeDocumentRequest.setDsDocumentMetaInfo(documentMetaInfo);
        this.client.target(this.baseuri).path("document").request().header(USER_ID, (Object)userID).header(PASSWORD, (Object)password).put(Entity.entity((Object)writeDocumentRequest, (MediaType)MediaType.APPLICATION_JSON_TYPE));
        LOGGER.debug("document " + fqn + " verschickt");
    }
}

