/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.adorsys.cryptoutils.exceptions.BaseException;
import org.adorsys.cryptoutils.exceptions.BaseExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlowInputStream
extends InputStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(SlowInputStream.class);
    private InputStream source;
    private Date firstRead = new Date();
    private int secsForOneChunk;
    private int chunkSize;
    private long readSoFar = 0L;

    public SlowInputStream(InputStream source, int secsForOneChunk, int chunkSize) {
        this.chunkSize = chunkSize;
        this.secsForOneChunk = secsForOneChunk;
        this.source = source;
        if (chunkSize <= 1) {
            throw new BaseException("chunk size has to be bigger than one");
        }
        if (secsForOneChunk < 1) {
            throw new BaseException("number of secs to wait has to be bigger than one");
        }
    }

    @Override
    public int read() throws IOException {
        int value = this.source.read();
        ++this.readSoFar;
        if (this.readSoFar % (long)this.chunkSize == 1L) {
            LOGGER.debug("returned so far " + this.readSoFar);
            int diff = this.getDiff();
            int numberOfChuncsAllowedToReadSoFar = diff / this.secsForOneChunk;
            if (this.readSoFar > (long)numberOfChuncsAllowedToReadSoFar) {
                this.sleep((numberOfChuncsAllowedToReadSoFar + 1) * this.secsForOneChunk - diff);
            }
        }
        return value;
    }

    private int getDiff() {
        Date now = new Date();
        long diff = now.getTime() - this.firstRead.getTime();
        LOGGER.debug("Zeit von " + this.firstRead + " bis " + now + " sind " + (diff /= 1000L) + " secs.");
        return (int)diff;
    }

    private void sleep(int secs) {
        LOGGER.debug("sleep for " + secs + " secs");
        try {
            Thread.currentThread();
            Thread.sleep(secs * 1000);
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
        LOGGER.debug("finished sleep for " + secs + " secs");
    }
}

