/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.adorsys.cryptoutils.exceptions.BaseException;
import org.adorsys.cryptoutils.exceptions.BaseExceptionHandler;
import org.adorsys.cryptoutils.utils.HexUtil;
import org.adorsys.docusafe.client.DocumentsafeRestClient;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger LOGGER = LoggerFactory.getLogger(Main.class);
    static final String BASEURI = "http://localhost:8080";
    public static final String USER_ID = "peter";
    public static final String PASSWORD = "rkp";

    public static void main(String[] args) {
        String filename;
        if (args.length == 0) {
            Main.error();
        }
        String action = args[0];
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
        DocumentsafeRestClient client = new DocumentsafeRestClient(BASEURI);
        if (action.equals("-cu")) {
            if (args.length != 1) {
                Main.error();
            }
            client.createUser(USER_ID, PASSWORD);
        }
        if (action.equals("-ws")) {
            if (args.length != 2) {
                Main.error();
            }
            filename = args[1];
            client.writeDocumentStream(USER_ID, PASSWORD, filename, Main.getAsInputStream(filename), new File(filename).length());
        }
        if (action.equals("-rs")) {
            if (args.length != 3) {
                Main.error();
            }
            filename = args[1];
            String localfilename = args[2];
            client.readDocumentStream(USER_ID, PASSWORD, filename, localfilename);
        }
        if (action.equals("-wb")) {
            if (args.length != 2) {
                Main.error();
            }
            filename = args[1];
            client.writeDocument(USER_ID, PASSWORD, filename, Main.getAsBytes(filename));
        }
        if (action.equals("-rb")) {
            if (args.length != 3) {
                Main.error();
            }
            String localfilename = args[2];
            String filename2 = args[1];
            client.readDocument(USER_ID, PASSWORD, filename2, localfilename);
        }
    }

    public static InputStream getAsInputStream(String filename) {
        try {
            return new FileInputStream(new File(filename));
        }
        catch (Exception e) {
            LOGGER.error("file:" + new File(filename).getAbsoluteFile());
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public static byte[] getAsBytes(String filename) {
        try {
            return FileUtils.readFileToByteArray((File)new File(filename));
        }
        catch (Exception e) {
            LOGGER.error("file:" + new File(filename).getAbsoluteFile());
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public static void showInputStream(InputStream inputStream) {
        try {
            LOGGER.debug("ok, receive an inputstream");
            int available = 0;
            int limit = 100;
            while ((available = inputStream.available()) > 0) {
                int min = Math.min(limit, available);
                byte[] bytes = new byte[min];
                int read = inputStream.read(bytes, 0, min);
                if (read != min) {
                    throw new BaseException("expected to read " + min + " bytes, but read " + read + " bytes");
                }
                LOGGER.debug("READ " + min + " bytes:" + HexUtil.convertBytesToHexString((byte[])bytes));
            }
            LOGGER.debug("finished reading");
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    private static void error() {
        LOGGER.debug("Pass params: -cu create user");
        LOGGER.debug("Pass params: -ws file (write stream)");
        LOGGER.debug("Pass params: -rs file localfile (read stream)");
        LOGGER.debug("Pass params: -wb file (write bytes)");
        LOGGER.debug("Pass params: -rb file localfilename (read bytes)");
        System.exit(1);
    }
}

