/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.docusafe.cached.transactional.impl;

import de.adorsys.dfs.connection.api.types.ListRecursiveFlag;
import de.adorsys.docusafe.business.types.DSDocument;
import de.adorsys.docusafe.business.types.DocumentDirectoryFQN;
import de.adorsys.docusafe.business.types.DocumentFQN;
import de.adorsys.docusafe.cached.transactional.exceptions.CacheException;
import de.adorsys.docusafe.service.api.types.UserIDAuth;
import de.adorsys.docusafe.transactional.TransactionalDocumentSafeService;
import de.adorsys.docusafe.transactional.impl.TxBucketContentFQNImpl;
import de.adorsys.docusafe.transactional.types.TxBucketContentFQN;
import de.adorsys.docusafe.transactional.types.TxDocumentFQNVersion;
import de.adorsys.docusafe.transactional.types.TxDocumentFQNWithVersion;
import de.adorsys.docusafe.transactional.types.TxID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CachedTransactionalContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachedTransactionalContext.class);
    private String id = UUID.randomUUID().toString() + " ";
    private Map<DocumentFQN, DSDocument> mapToStore = null;
    private Map<DocumentFQN, DSDocument> mapToRead = null;
    private Set<DocumentFQN> setToDelete = null;
    private TransactionalDocumentSafeService transactionalFileStorage = null;
    private TxBucketContentFQN bucketContent = null;
    private TxID txID;

    public CachedTransactionalContext(TransactionalDocumentSafeService transactionalFileStorage, TxID txID) {
        this.transactionalFileStorage = transactionalFileStorage;
        this.txID = txID;
        this.mapToStore = new HashMap<DocumentFQN, DSDocument>();
        this.mapToRead = new HashMap<DocumentFQN, DSDocument>();
        this.setToDelete = new HashSet<DocumentFQN>();
    }

    public void txStoreDocument(DSDocument dsDocument) {
        this.setToDelete.remove(dsDocument.getDocumentFQN());
        this.mapToStore.put(dsDocument.getDocumentFQN(), dsDocument);
        this.mapToRead.put(dsDocument.getDocumentFQN(), dsDocument);
    }

    public DSDocument txReadDocument(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        if (this.mapToRead.containsKey(documentFQN)) {
            return this.mapToRead.get(documentFQN);
        }
        if (this.setToDelete.contains(documentFQN)) {
            throw new CacheException("document " + documentFQN + " has been deleted before. can not be read");
        }
        DSDocument dsDocument = this.transactionalFileStorage.txReadDocument(userIDAuth, documentFQN);
        this.mapToRead.put(dsDocument.getDocumentFQN(), dsDocument);
        return dsDocument;
    }

    public void txDeleteDocument(DocumentFQN documentFQN) {
        this.setToDelete.add(documentFQN);
        this.mapToStore.remove(documentFQN);
        this.mapToRead.remove(documentFQN);
    }

    public TxBucketContentFQN txListDocuments(UserIDAuth userIDAuth, DocumentDirectoryFQN documentDirectoryFQN, ListRecursiveFlag recursiveFlag) {
        if (this.bucketContent == null) {
            this.bucketContent = this.transactionalFileStorage.txListDocuments(userIDAuth, new DocumentDirectoryFQN("/"), ListRecursiveFlag.TRUE);
        }
        TxBucketContentFQNImpl ret = new TxBucketContentFQNImpl();
        this.bucketContent.getFilesWithVersion().forEach(arg_0 -> CachedTransactionalContext.lambda$txListDocuments$0(documentDirectoryFQN, recursiveFlag, (TxBucketContentFQN)ret, arg_0));
        ret.getFiles().removeAll(this.setToDelete);
        HashSet<TxDocumentFQNWithVersion> setToDeleteWithVersion = new HashSet<TxDocumentFQNWithVersion>();
        for (TxDocumentFQNWithVersion documentFQNWithVersion : ret.getFilesWithVersion()) {
            if (!this.setToDelete.contains(documentFQNWithVersion.getDocumentFQN())) continue;
            setToDeleteWithVersion.add(documentFQNWithVersion);
        }
        ret.getFilesWithVersion().removeAll(setToDeleteWithVersion);
        this.mapToStore.keySet().forEach(arg_0 -> this.lambda$txListDocuments$1(documentDirectoryFQN, (TxBucketContentFQN)ret, arg_0));
        HashSet allFiles = new HashSet(ret.getFiles());
        ret.getFiles().clear();
        ret.getFiles().addAll(new ArrayList(allFiles));
        HashSet allFilesWithVersion = new HashSet(ret.getFilesWithVersion());
        ret.getFilesWithVersion().clear();
        ret.getFilesWithVersion().addAll(new ArrayList(allFilesWithVersion));
        return ret;
    }

    public boolean txDocumentExists(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        if (this.setToDelete.contains(documentFQN)) {
            return false;
        }
        if (this.mapToStore.containsKey(documentFQN)) {
            return true;
        }
        return this.transactionalFileStorage.txDocumentExists(userIDAuth, documentFQN);
    }

    public void endTransaction(UserIDAuth userIDAuth) {
        this.setToDelete.forEach(documentFQN -> this.transactionalFileStorage.txDeleteDocument(userIDAuth, documentFQN));
        this.mapToStore.keySet().forEach(documentFQN -> this.transactionalFileStorage.txStoreDocument(userIDAuth, this.mapToStore.get(documentFQN)));
        this.transactionalFileStorage.endTransaction(userIDAuth);
    }

    public void freeMemory() {
        int numWrite = this.mapToStore.size();
        int numRead = this.mapToRead.size();
        long sumWrite = this.mapToStore.values().stream().mapToLong(dsDocument -> dsDocument.getDocumentContent().getValue().length).sum();
        long sumRead = this.mapToRead.values().stream().mapToLong(dsDocument -> dsDocument.getDocumentContent().getValue().length).sum();
        LOGGER.debug("freeMemory(" + numWrite + ":" + sumWrite + ", " + numRead + ":" + sumRead + ")");
        this.mapToStore.clear();
        this.mapToRead.clear();
        this.setToDelete.clear();
        this.transactionalFileStorage = null;
        this.bucketContent = null;
    }

    private /* synthetic */ void lambda$txListDocuments$1(DocumentDirectoryFQN documentDirectoryFQN, TxBucketContentFQN ret, DocumentFQN documentFQN) {
        if (documentFQN.getDocumentDirectory().getValue().startsWith(documentDirectoryFQN.getValue())) {
            ret.getFiles().add(documentFQN);
            ret.getFilesWithVersion().add(new TxDocumentFQNWithVersion(documentFQN, new TxDocumentFQNVersion(this.txID.getValue())));
        }
    }

    private static /* synthetic */ void lambda$txListDocuments$0(DocumentDirectoryFQN documentDirectoryFQN, ListRecursiveFlag recursiveFlag, TxBucketContentFQN ret, TxDocumentFQNWithVersion file) {
        if (file.getDocumentFQN().getValue().startsWith(documentDirectoryFQN.getValue())) {
            if (recursiveFlag.equals((Object)ListRecursiveFlag.TRUE)) {
                ret.getFiles().add(file.getDocumentFQN());
                ret.getFilesWithVersion().add(file);
            } else {
                String fileWithoutRoot = file.getDocumentFQN().getValue().substring(documentDirectoryFQN.getValue().length());
                if (fileWithoutRoot.lastIndexOf("/") == 0) {
                    ret.getFiles().add(file.getDocumentFQN());
                    ret.getFilesWithVersion().add(file);
                }
            }
        }
    }
}

