/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.cached.transactional.impl;

import org.adorsys.cryptoutils.exceptions.BaseException;
import org.adorsys.docusafe.business.types.UserID;
import org.adorsys.docusafe.business.types.complex.BucketContentFQN;
import org.adorsys.docusafe.business.types.complex.DSDocument;
import org.adorsys.docusafe.business.types.complex.DocumentDirectoryFQN;
import org.adorsys.docusafe.business.types.complex.DocumentFQN;
import org.adorsys.docusafe.business.types.complex.UserIDAuth;
import org.adorsys.docusafe.cached.transactional.CachedTransactionalDocumentSafeService;
import org.adorsys.docusafe.cached.transactional.exceptions.CacheException;
import org.adorsys.docusafe.cached.transactional.impl.CachedTransactionalContext;
import org.adorsys.docusafe.cached.transactional.impl.CachedTransactionalContextMap;
import org.adorsys.docusafe.transactional.RequestMemoryContext;
import org.adorsys.docusafe.transactional.TransactionalDocumentSafeService;
import org.adorsys.docusafe.transactional.exceptions.TxNotActiveException;
import org.adorsys.docusafe.transactional.impl.CurrentTransactionsMap;
import org.adorsys.docusafe.transactional.types.TxID;
import org.adorsys.encobject.types.ListRecursiveFlag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedTransactionalDocumentSafeServiceImpl
implements CachedTransactionalDocumentSafeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachedTransactionalDocumentSafeServiceImpl.class);
    public static final String CACHEND_TRANSACTIONAL_CONTEXT_MAP = "cachendTransactionalContextMap";
    private TransactionalDocumentSafeService transactionalFileStorage;
    private RequestMemoryContext requestContext;

    public CachedTransactionalDocumentSafeServiceImpl(RequestMemoryContext requestContext, TransactionalDocumentSafeService transactionalFileStorage) {
        this.transactionalFileStorage = transactionalFileStorage;
        this.requestContext = requestContext;
    }

    public void createUser(UserIDAuth userIDAuth) {
        this.transactionalFileStorage.createUser(userIDAuth);
    }

    public void destroyUser(UserIDAuth userIDAuth) {
        this.transactionalFileStorage.destroyUser(userIDAuth);
    }

    public boolean userExists(UserID userID) {
        return this.transactionalFileStorage.userExists(userID);
    }

    public void grantAccessToNonTxFolder(UserIDAuth userIDAuth, UserID receiverUserID, DocumentDirectoryFQN documentDirectoryFQN) {
        this.transactionalFileStorage.grantAccessToNonTxFolder(userIDAuth, receiverUserID, documentDirectoryFQN);
    }

    public void nonTxStoreDocument(UserIDAuth userIDAuth, DSDocument dsDocument) {
        this.transactionalFileStorage.nonTxStoreDocument(userIDAuth, dsDocument);
    }

    public void nonTxStoreDocument(UserIDAuth userIDAuth, UserID documentOwner, DSDocument dsDocument) {
        this.transactionalFileStorage.nonTxStoreDocument(userIDAuth, documentOwner, dsDocument);
    }

    public DSDocument nonTxReadDocument(UserIDAuth userIDAuth, UserID documentOwner, DocumentFQN documentFQN) {
        return this.transactionalFileStorage.nonTxReadDocument(userIDAuth, documentOwner, documentFQN);
    }

    public DSDocument nonTxReadDocument(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        return this.transactionalFileStorage.nonTxReadDocument(userIDAuth, documentFQN);
    }

    public boolean nonTxDocumentExists(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        return this.transactionalFileStorage.nonTxDocumentExists(userIDAuth, documentFQN);
    }

    public boolean nonTxDocumentExists(UserIDAuth userIDAuth, UserID documentOwner, DocumentFQN documentFQN) {
        return this.transactionalFileStorage.nonTxDocumentExists(userIDAuth, documentOwner, documentFQN);
    }

    public void nonTxDeleteDocument(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        this.transactionalFileStorage.nonTxDeleteDocument(userIDAuth, documentFQN);
    }

    public BucketContentFQN nonTxListDocuments(UserIDAuth userIDAuth, DocumentDirectoryFQN documentDirectoryFQN, ListRecursiveFlag recursiveFlag) {
        return this.transactionalFileStorage.nonTxListDocuments(userIDAuth, documentDirectoryFQN, recursiveFlag);
    }

    public void beginTransaction(UserIDAuth userIDAuth) {
        this.transactionalFileStorage.beginTransaction(userIDAuth);
        this.createTransactionalContext(this.getCurrentTxID());
    }

    public void txStoreDocument(UserIDAuth userIDAuth, DSDocument dsDocument) {
        this.getTransactionalContext(this.getCurrentTxID()).txStoreDocument(dsDocument);
    }

    public DSDocument txReadDocument(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        return this.getTransactionalContext(this.getCurrentTxID()).txReadDocument(userIDAuth, documentFQN);
    }

    public void txDeleteDocument(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        this.getTransactionalContext(this.getCurrentTxID()).txDeleteDocument(documentFQN);
    }

    public BucketContentFQN txListDocuments(UserIDAuth userIDAuth, DocumentDirectoryFQN documentDirectoryFQN, ListRecursiveFlag recursiveFlag) {
        return this.getTransactionalContext(this.getCurrentTxID()).txListDocuments(userIDAuth, documentDirectoryFQN, recursiveFlag);
    }

    public boolean txDocumentExists(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        return this.getTransactionalContext(this.getCurrentTxID()).txDocumentExists(this.getCurrentTxID(), userIDAuth, documentFQN);
    }

    public void txDeleteFolder(UserIDAuth userIDAuth, DocumentDirectoryFQN documentDirectoryFQN) {
        throw new BaseException("Who needs this interface");
    }

    public void endTransaction(UserIDAuth userIDAuth) {
        TxID txid = this.getCurrentTxID();
        this.getTransactionalContext(txid).endTransaction(userIDAuth);
        this.deleteTransactionalContext(txid);
    }

    private CachedTransactionalContext createTransactionalContext(TxID txid) {
        CachedTransactionalContextMap cachedTransactionalContextMap = (CachedTransactionalContextMap)this.requestContext.get((Object)CACHEND_TRANSACTIONAL_CONTEXT_MAP);
        if (cachedTransactionalContextMap == null) {
            cachedTransactionalContextMap = new CachedTransactionalContextMap();
            this.requestContext.put((Object)CACHEND_TRANSACTIONAL_CONTEXT_MAP, (Object)cachedTransactionalContextMap);
        }
        CachedTransactionalContext cachedTransactionalContext = new CachedTransactionalContext(this.transactionalFileStorage);
        cachedTransactionalContextMap.put(txid, cachedTransactionalContext);
        return cachedTransactionalContext;
    }

    private CachedTransactionalContext getTransactionalContext(TxID txid) {
        CachedTransactionalContextMap cachedTransactionalContextMap = (CachedTransactionalContextMap)this.requestContext.get((Object)CACHEND_TRANSACTIONAL_CONTEXT_MAP);
        if (cachedTransactionalContextMap == null) {
            throw new CacheException("RequestContext has no CachedTransactionalContextMap. So Context for " + txid + " can not be searched");
        }
        CachedTransactionalContext cachedTransactionalContext = (CachedTransactionalContext)cachedTransactionalContextMap.get(txid);
        if (cachedTransactionalContext == null) {
            throw new CacheException("CachedTransactionalContextMap has no CachedContext for " + txid);
        }
        return cachedTransactionalContext;
    }

    private void deleteTransactionalContext(TxID txid) {
        CachedTransactionalContextMap cachedTransactionalContextMap = (CachedTransactionalContextMap)this.requestContext.get((Object)CACHEND_TRANSACTIONAL_CONTEXT_MAP);
        if (cachedTransactionalContextMap == null) {
            throw new CacheException("RequestContext has no CachedTransactionalContextMap. So Context for " + txid + " can not be searched");
        }
        CachedTransactionalContext cachedTransactionalContext = (CachedTransactionalContext)cachedTransactionalContextMap.get(txid);
        if (cachedTransactionalContext == null) {
            throw new CacheException("CachedTransactionalContextMap has no CachedContext for " + txid);
        }
        LOGGER.debug("freeMemory() of tx " + txid);
        cachedTransactionalContext.freeMemory();
        cachedTransactionalContextMap.remove(txid);
    }

    public TxID getCurrentTxID() {
        CurrentTransactionsMap currentTransactionsMap = this.getCurrentTransactionMap();
        TxID txID = currentTransactionsMap.getCurrentTxID();
        if (txID == null) {
            throw new TxNotActiveException();
        }
        return txID;
    }

    private CurrentTransactionsMap getCurrentTransactionMap() {
        CurrentTransactionsMap currentTransactionsMap = (CurrentTransactionsMap)this.requestContext.get((Object)"CurrentTransactionsMap");
        if (currentTransactionsMap == null) {
            throw new TxNotActiveException();
        }
        return currentTransactionsMap;
    }
}

