/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.cached.transactional.impl;

import de.adorsys.dfs.connection.api.filesystem.exceptions.FileNotFoundException;
import de.adorsys.dfs.connection.api.types.ListRecursiveFlag;
import java.util.List;
import org.adorsys.docusafe.business.DocumentSafeService;
import org.adorsys.docusafe.business.types.DSDocument;
import org.adorsys.docusafe.business.types.DocumentDirectoryFQN;
import org.adorsys.docusafe.business.types.DocumentFQN;
import org.adorsys.docusafe.business.types.MoveType;
import org.adorsys.docusafe.cached.transactional.CachedTransactionalDocumentSafeService;
import org.adorsys.docusafe.cached.transactional.exceptions.CacheException;
import org.adorsys.docusafe.cached.transactional.impl.CachedTransactionalContext;
import org.adorsys.docusafe.cached.transactional.impl.CachedTransactionalContextMap;
import org.adorsys.docusafe.service.api.types.UserID;
import org.adorsys.docusafe.service.api.types.UserIDAuth;
import org.adorsys.docusafe.transactional.RequestMemoryContext;
import org.adorsys.docusafe.transactional.TransactionalDocumentSafeService;
import org.adorsys.docusafe.transactional.exceptions.TxNotActiveException;
import org.adorsys.docusafe.transactional.impl.CurrentTransactionData;
import org.adorsys.docusafe.transactional.types.TxBucketContentFQN;
import org.adorsys.docusafe.transactional.types.TxDocumentFQNVersion;
import org.adorsys.docusafe.transactional.types.TxDocumentFQNWithVersion;
import org.adorsys.docusafe.transactional.types.TxID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedTransactionalDocumentSafeServiceImpl
implements CachedTransactionalDocumentSafeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachedTransactionalDocumentSafeServiceImpl.class);
    public static final String CACHEND_TRANSACTIONAL_CONTEXT_MAP = "cachendTransactionalContextMap";
    private TransactionalDocumentSafeService transactionalDocumentSafeService;
    private RequestMemoryContext requestMemoryContext;
    private DocumentSafeService documentSafeService;

    public CachedTransactionalDocumentSafeServiceImpl(RequestMemoryContext requestMemoryContext, TransactionalDocumentSafeService transactionalDocumentSafeService, DocumentSafeService documentSafeService) {
        this.transactionalDocumentSafeService = transactionalDocumentSafeService;
        this.documentSafeService = documentSafeService;
        this.requestMemoryContext = requestMemoryContext;
    }

    public void createUser(UserIDAuth userIDAuth) {
        this.transactionalDocumentSafeService.createUser(userIDAuth);
    }

    public void destroyUser(UserIDAuth userIDAuth) {
        this.transactionalDocumentSafeService.destroyUser(userIDAuth);
    }

    public boolean userExists(UserID userID) {
        return this.transactionalDocumentSafeService.userExists(userID);
    }

    public List<DocumentFQN> nonTxListInbox(UserIDAuth userIDAuth) {
        return this.transactionalDocumentSafeService.nonTxListInbox(userIDAuth);
    }

    public void beginTransaction(UserIDAuth userIDAuth) {
        this.transactionalDocumentSafeService.beginTransaction(userIDAuth);
        this.createTransactionalContext(this.getCurrentTxID(userIDAuth.getUserID()));
    }

    public void txStoreDocument(UserIDAuth userIDAuth, DSDocument dsDocument) {
        this.getTransactionalContext(this.getCurrentTxID(userIDAuth.getUserID())).txStoreDocument(dsDocument);
    }

    public DSDocument txReadDocument(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        return this.getTransactionalContext(this.getCurrentTxID(userIDAuth.getUserID())).txReadDocument(userIDAuth, documentFQN);
    }

    public void txDeleteDocument(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        this.getTransactionalContext(this.getCurrentTxID(userIDAuth.getUserID())).txDeleteDocument(documentFQN);
    }

    public TxBucketContentFQN txListDocuments(UserIDAuth userIDAuth, DocumentDirectoryFQN documentDirectoryFQN, ListRecursiveFlag recursiveFlag) {
        return this.getTransactionalContext(this.getCurrentTxID(userIDAuth.getUserID())).txListDocuments(userIDAuth, documentDirectoryFQN, recursiveFlag);
    }

    public TxDocumentFQNVersion getVersion(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        TxBucketContentFQN txBucketContentFQN = this.txListDocuments(userIDAuth, documentFQN.getDocumentDirectory(), ListRecursiveFlag.FALSE);
        if (txBucketContentFQN.getFilesWithVersion().isEmpty()) {
            throw new FileNotFoundException(documentFQN.getValue(), null);
        }
        return ((TxDocumentFQNWithVersion)txBucketContentFQN.getFilesWithVersion().stream().findFirst().get()).getVersion();
    }

    public boolean txDocumentExists(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        return this.getTransactionalContext(this.getCurrentTxID(userIDAuth.getUserID())).txDocumentExists(userIDAuth, documentFQN);
    }

    public void txDeleteFolder(UserIDAuth userIDAuth, DocumentDirectoryFQN documentDirectoryFQN) {
        TxBucketContentFQN txBucketContentFQN = this.getTransactionalContext(this.getCurrentTxID(userIDAuth.getUserID())).txListDocuments(userIDAuth, documentDirectoryFQN, ListRecursiveFlag.TRUE);
        txBucketContentFQN.getFiles().stream().forEach(documentFQN -> this.txDeleteDocument(userIDAuth, (DocumentFQN)documentFQN));
    }

    public void endTransaction(UserIDAuth userIDAuth) {
        TxID txid = this.getCurrentTxID(userIDAuth.getUserID());
        this.getTransactionalContext(txid).endTransaction(userIDAuth);
        this.deleteTransactionalContext(txid);
    }

    public void txMoveDocumentToInboxOfUser(UserIDAuth userIDAuth, UserID receiverUserID, DocumentFQN sourceDocumentFQN, DocumentFQN destDocumentFQN, MoveType moveType) {
        LOGGER.debug("start txMoveDocumentToInboxOfUser from " + userIDAuth.getUserID() + " " + sourceDocumentFQN + " to " + receiverUserID + " " + destDocumentFQN);
        DSDocument document = this.txReadDocument(userIDAuth, sourceDocumentFQN);
        this.documentSafeService.writeDocumentToInboxOfUser(receiverUserID, document, destDocumentFQN);
        if (moveType.equals((Object)MoveType.MOVE)) {
            this.txDeleteDocument(userIDAuth, sourceDocumentFQN);
        }
        LOGGER.debug("finished txMoveDocumentToInboxOfUser from " + userIDAuth.getUserID() + " " + sourceDocumentFQN + " to " + receiverUserID + " " + destDocumentFQN);
    }

    public DSDocument txMoveDocumentFromInbox(UserIDAuth userIDAuth, DocumentFQN source, DocumentFQN destination) {
        LOGGER.debug("start nonTxReadFromInbox for " + userIDAuth + " " + source + " to " + destination);
        DSDocument dsDocumentFromInbox = this.documentSafeService.readDocumentFromInbox(userIDAuth, source);
        DSDocument dsDocument = new DSDocument(destination, dsDocumentFromInbox.getDocumentContent());
        this.txStoreDocument(userIDAuth, dsDocument);
        this.getCurrentTransactionData(userIDAuth.getUserID()).addNonTxInboxFileToBeDeletedAfterCommit(source);
        LOGGER.debug("finishdd nonTxReadFromInbox for " + userIDAuth + " " + source + " to " + destination);
        return this.txReadDocument(userIDAuth, destination);
    }

    private CachedTransactionalContext createTransactionalContext(TxID txid) {
        CachedTransactionalContextMap cachedTransactionalContextMap = (CachedTransactionalContextMap)this.requestMemoryContext.get((Object)CACHEND_TRANSACTIONAL_CONTEXT_MAP);
        if (cachedTransactionalContextMap == null) {
            cachedTransactionalContextMap = new CachedTransactionalContextMap();
            this.requestMemoryContext.put((Object)CACHEND_TRANSACTIONAL_CONTEXT_MAP, (Object)cachedTransactionalContextMap);
        }
        CachedTransactionalContext cachedTransactionalContext = new CachedTransactionalContext(this.transactionalDocumentSafeService, txid);
        cachedTransactionalContextMap.put(txid, cachedTransactionalContext);
        return cachedTransactionalContext;
    }

    private CachedTransactionalContext getTransactionalContext(TxID txid) {
        CachedTransactionalContextMap cachedTransactionalContextMap = (CachedTransactionalContextMap)this.requestMemoryContext.get((Object)CACHEND_TRANSACTIONAL_CONTEXT_MAP);
        if (cachedTransactionalContextMap == null) {
            throw new CacheException("RequestContext has no CachedTransactionalContextMap. So Context for " + txid + " can not be searched");
        }
        CachedTransactionalContext cachedTransactionalContext = (CachedTransactionalContext)cachedTransactionalContextMap.get(txid);
        if (cachedTransactionalContext == null) {
            throw new CacheException("CachedTransactionalContextMap has no CachedContext for " + txid);
        }
        return cachedTransactionalContext;
    }

    private void deleteTransactionalContext(TxID txid) {
        CachedTransactionalContextMap cachedTransactionalContextMap = (CachedTransactionalContextMap)this.requestMemoryContext.get((Object)CACHEND_TRANSACTIONAL_CONTEXT_MAP);
        if (cachedTransactionalContextMap == null) {
            throw new CacheException("RequestContext has no CachedTransactionalContextMap. So Context for " + txid + " can not be searched");
        }
        CachedTransactionalContext cachedTransactionalContext = (CachedTransactionalContext)cachedTransactionalContextMap.get(txid);
        if (cachedTransactionalContext == null) {
            throw new CacheException("CachedTransactionalContextMap has no CachedContext for " + txid);
        }
        LOGGER.debug("freeMemory() of tx " + txid);
        cachedTransactionalContext.freeMemory();
        cachedTransactionalContextMap.remove(txid);
    }

    public TxID getCurrentTxID(UserID userID) {
        CurrentTransactionData currentTransactionData = this.getCurrentTransactionData(userID);
        TxID txID = currentTransactionData.getCurrentTxID();
        if (txID == null) {
            throw new TxNotActiveException(userID);
        }
        return txID;
    }

    private CurrentTransactionData getCurrentTransactionData(UserID userID) {
        CurrentTransactionData currentTransactionData = (CurrentTransactionData)this.requestMemoryContext.get((Object)("CurrentTransactionData-" + userID.getValue()));
        if (currentTransactionData == null) {
            throw new TxNotActiveException(userID);
        }
        return currentTransactionData;
    }
}

