/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.cached.transactional.impl;

import org.adorsys.docusafe.business.types.UserID;
import org.adorsys.docusafe.business.types.complex.BucketContentFQN;
import org.adorsys.docusafe.business.types.complex.DSDocument;
import org.adorsys.docusafe.business.types.complex.DocumentDirectoryFQN;
import org.adorsys.docusafe.business.types.complex.DocumentFQN;
import org.adorsys.docusafe.business.types.complex.UserIDAuth;
import org.adorsys.docusafe.cached.transactional.CachedTransactionalDocumentSafeService;
import org.adorsys.docusafe.cached.transactional.exceptions.CacheException;
import org.adorsys.docusafe.cached.transactional.impl.CachedTransactionalContext;
import org.adorsys.docusafe.cached.transactional.impl.CachedTransactionalContextMap;
import org.adorsys.docusafe.transactional.RequestMemoryContext;
import org.adorsys.docusafe.transactional.TransactionalDocumentSafeService;
import org.adorsys.docusafe.transactional.exceptions.TxNotActiveException;
import org.adorsys.docusafe.transactional.impl.CurrentTransactionData;
import org.adorsys.docusafe.transactional.types.TxBucketContentFQN;
import org.adorsys.docusafe.transactional.types.TxDocumentFQNVersion;
import org.adorsys.docusafe.transactional.types.TxDocumentFQNWithVersion;
import org.adorsys.docusafe.transactional.types.TxID;
import org.adorsys.encobject.filesystem.exceptions.FileNotFoundException;
import org.adorsys.encobject.types.ListRecursiveFlag;
import org.adorsys.encobject.types.PublicKeyJWK;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedTransactionalDocumentSafeServiceImpl
implements CachedTransactionalDocumentSafeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachedTransactionalDocumentSafeServiceImpl.class);
    public static final String CACHEND_TRANSACTIONAL_CONTEXT_MAP = "cachendTransactionalContextMap";
    private TransactionalDocumentSafeService transactionalFileStorage;
    private RequestMemoryContext requestMemoryContext;

    public CachedTransactionalDocumentSafeServiceImpl(RequestMemoryContext requestMemoryContext, TransactionalDocumentSafeService transactionalFileStorage) {
        this.transactionalFileStorage = transactionalFileStorage;
        this.requestMemoryContext = requestMemoryContext;
    }

    public void createUser(UserIDAuth userIDAuth) {
        this.transactionalFileStorage.createUser(userIDAuth);
    }

    public void destroyUser(UserIDAuth userIDAuth) {
        this.transactionalFileStorage.destroyUser(userIDAuth);
    }

    public boolean userExists(UserID userID) {
        return this.transactionalFileStorage.userExists(userID);
    }

    public void grantAccessToNonTxFolder(UserIDAuth userIDAuth, UserID receiverUserID, DocumentDirectoryFQN documentDirectoryFQN) {
        this.transactionalFileStorage.grantAccessToNonTxFolder(userIDAuth, receiverUserID, documentDirectoryFQN);
    }

    public PublicKeyJWK findPublicEncryptionKey(UserID userID) {
        return this.transactionalFileStorage.findPublicEncryptionKey(userID);
    }

    public void nonTxStoreDocument(UserIDAuth userIDAuth, DSDocument dsDocument) {
        this.transactionalFileStorage.nonTxStoreDocument(userIDAuth, dsDocument);
    }

    public void nonTxStoreDocument(UserIDAuth userIDAuth, UserID documentOwner, DSDocument dsDocument) {
        this.transactionalFileStorage.nonTxStoreDocument(userIDAuth, documentOwner, dsDocument);
    }

    public DSDocument nonTxReadDocument(UserIDAuth userIDAuth, UserID documentOwner, DocumentFQN documentFQN) {
        return this.transactionalFileStorage.nonTxReadDocument(userIDAuth, documentOwner, documentFQN);
    }

    public DSDocument nonTxReadDocument(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        return this.transactionalFileStorage.nonTxReadDocument(userIDAuth, documentFQN);
    }

    public boolean nonTxDocumentExists(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        return this.transactionalFileStorage.nonTxDocumentExists(userIDAuth, documentFQN);
    }

    public boolean nonTxDocumentExists(UserIDAuth userIDAuth, UserID documentOwner, DocumentFQN documentFQN) {
        return this.transactionalFileStorage.nonTxDocumentExists(userIDAuth, documentOwner, documentFQN);
    }

    public void nonTxDeleteDocument(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        this.transactionalFileStorage.nonTxDeleteDocument(userIDAuth, documentFQN);
    }

    public void nonTxDeleteFolder(UserIDAuth userIDAuth, DocumentDirectoryFQN documentDirectoryFQN) {
        this.transactionalFileStorage.nonTxDeleteFolder(userIDAuth, documentDirectoryFQN);
    }

    public BucketContentFQN nonTxListDocuments(UserIDAuth userIDAuth, DocumentDirectoryFQN documentDirectoryFQN, ListRecursiveFlag recursiveFlag) {
        return this.transactionalFileStorage.nonTxListDocuments(userIDAuth, documentDirectoryFQN, recursiveFlag);
    }

    public void beginTransaction(UserIDAuth userIDAuth) {
        this.transactionalFileStorage.beginTransaction(userIDAuth);
        this.createTransactionalContext(this.getCurrentTxID(userIDAuth.getUserID()));
    }

    public void txStoreDocument(UserIDAuth userIDAuth, DSDocument dsDocument) {
        this.getTransactionalContext(this.getCurrentTxID(userIDAuth.getUserID())).txStoreDocument(dsDocument);
    }

    public DSDocument txReadDocument(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        return this.getTransactionalContext(this.getCurrentTxID(userIDAuth.getUserID())).txReadDocument(userIDAuth, documentFQN);
    }

    public void txDeleteDocument(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        this.getTransactionalContext(this.getCurrentTxID(userIDAuth.getUserID())).txDeleteDocument(documentFQN);
    }

    public TxBucketContentFQN txListDocuments(UserIDAuth userIDAuth, DocumentDirectoryFQN documentDirectoryFQN, ListRecursiveFlag recursiveFlag) {
        return this.getTransactionalContext(this.getCurrentTxID(userIDAuth.getUserID())).txListDocuments(userIDAuth, documentDirectoryFQN, recursiveFlag);
    }

    public TxDocumentFQNVersion getVersion(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        TxBucketContentFQN txBucketContentFQN = this.txListDocuments(userIDAuth, documentFQN.getDocumentDirectory(), ListRecursiveFlag.FALSE);
        if (txBucketContentFQN.getFilesWithVersion().isEmpty()) {
            throw new FileNotFoundException(documentFQN.getValue(), null);
        }
        return ((TxDocumentFQNWithVersion)txBucketContentFQN.getFilesWithVersion().stream().findFirst().get()).getVersion();
    }

    public boolean txDocumentExists(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        return this.getTransactionalContext(this.getCurrentTxID(userIDAuth.getUserID())).txDocumentExists(userIDAuth, documentFQN);
    }

    public void txDeleteFolder(UserIDAuth userIDAuth, DocumentDirectoryFQN documentDirectoryFQN) {
        TxBucketContentFQN txBucketContentFQN = this.getTransactionalContext(this.getCurrentTxID(userIDAuth.getUserID())).txListDocuments(userIDAuth, documentDirectoryFQN, ListRecursiveFlag.TRUE);
        txBucketContentFQN.getFiles().stream().forEach(documentFQN -> this.txDeleteDocument(userIDAuth, (DocumentFQN)documentFQN));
    }

    public void transferFromNonTxToTx(UserIDAuth userIDAuth, DocumentFQN nonTxFQN, DocumentFQN txFQN) {
        DSDocument nonTxDsDocument = this.nonTxReadDocument(userIDAuth, nonTxFQN);
        DSDocument txDsDocument = new DSDocument(txFQN, nonTxDsDocument.getDocumentContent(), nonTxDsDocument.getDsDocumentMetaInfo());
        this.txStoreDocument(userIDAuth, txDsDocument);
        this.getCurrentTransactionData(userIDAuth.getUserID()).addNonTxFileToBeDeletedAfterCommit(nonTxFQN);
    }

    public void endTransaction(UserIDAuth userIDAuth) {
        TxID txid = this.getCurrentTxID(userIDAuth.getUserID());
        this.getTransactionalContext(txid).endTransaction(userIDAuth);
        this.deleteTransactionalContext(txid);
    }

    private CachedTransactionalContext createTransactionalContext(TxID txid) {
        CachedTransactionalContextMap cachedTransactionalContextMap = (CachedTransactionalContextMap)this.requestMemoryContext.get((Object)CACHEND_TRANSACTIONAL_CONTEXT_MAP);
        if (cachedTransactionalContextMap == null) {
            cachedTransactionalContextMap = new CachedTransactionalContextMap();
            this.requestMemoryContext.put((Object)CACHEND_TRANSACTIONAL_CONTEXT_MAP, (Object)cachedTransactionalContextMap);
        }
        CachedTransactionalContext cachedTransactionalContext = new CachedTransactionalContext(this.transactionalFileStorage, txid);
        cachedTransactionalContextMap.put(txid, cachedTransactionalContext);
        return cachedTransactionalContext;
    }

    private CachedTransactionalContext getTransactionalContext(TxID txid) {
        CachedTransactionalContextMap cachedTransactionalContextMap = (CachedTransactionalContextMap)this.requestMemoryContext.get((Object)CACHEND_TRANSACTIONAL_CONTEXT_MAP);
        if (cachedTransactionalContextMap == null) {
            throw new CacheException("RequestContext has no CachedTransactionalContextMap. So Context for " + txid + " can not be searched");
        }
        CachedTransactionalContext cachedTransactionalContext = (CachedTransactionalContext)cachedTransactionalContextMap.get(txid);
        if (cachedTransactionalContext == null) {
            throw new CacheException("CachedTransactionalContextMap has no CachedContext for " + txid);
        }
        return cachedTransactionalContext;
    }

    private void deleteTransactionalContext(TxID txid) {
        CachedTransactionalContextMap cachedTransactionalContextMap = (CachedTransactionalContextMap)this.requestMemoryContext.get((Object)CACHEND_TRANSACTIONAL_CONTEXT_MAP);
        if (cachedTransactionalContextMap == null) {
            throw new CacheException("RequestContext has no CachedTransactionalContextMap. So Context for " + txid + " can not be searched");
        }
        CachedTransactionalContext cachedTransactionalContext = (CachedTransactionalContext)cachedTransactionalContextMap.get(txid);
        if (cachedTransactionalContext == null) {
            throw new CacheException("CachedTransactionalContextMap has no CachedContext for " + txid);
        }
        LOGGER.debug("freeMemory() of tx " + txid);
        cachedTransactionalContext.freeMemory();
        cachedTransactionalContextMap.remove(txid);
    }

    public TxID getCurrentTxID(UserID userID) {
        CurrentTransactionData currentTransactionData = this.getCurrentTransactionData(userID);
        TxID txID = currentTransactionData.getCurrentTxID();
        if (txID == null) {
            throw new TxNotActiveException(userID);
        }
        return txID;
    }

    private CurrentTransactionData getCurrentTransactionData(UserID userID) {
        CurrentTransactionData currentTransactionData = (CurrentTransactionData)this.requestMemoryContext.get((Object)("CurrentTransactionData-" + userID.getValue()));
        if (currentTransactionData == null) {
            throw new TxNotActiveException(userID);
        }
        return currentTransactionData;
    }
}

