/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.cached.transactional.impl;

import org.adorsys.cryptoutils.exceptions.BaseException;
import org.adorsys.docusafe.business.types.UserID;
import org.adorsys.docusafe.business.types.complex.BucketContentFQN;
import org.adorsys.docusafe.business.types.complex.DSDocument;
import org.adorsys.docusafe.business.types.complex.DocumentDirectoryFQN;
import org.adorsys.docusafe.business.types.complex.DocumentFQN;
import org.adorsys.docusafe.business.types.complex.UserIDAuth;
import org.adorsys.docusafe.cached.transactional.CachedTransactionalDocumentSafeService;
import org.adorsys.docusafe.cached.transactional.exceptions.CacheException;
import org.adorsys.docusafe.cached.transactional.impl.CachedTransactionalContext;
import org.adorsys.docusafe.cached.transactional.impl.CachedTransactionalContextMap;
import org.adorsys.docusafe.transactional.RequestMemoryContext;
import org.adorsys.docusafe.transactional.TransactionalDocumentSafeService;
import org.adorsys.docusafe.transactional.types.TxID;
import org.adorsys.encobject.types.ListRecursiveFlag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedTransactionalDocumentSafeServiceImpl
implements CachedTransactionalDocumentSafeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachedTransactionalDocumentSafeServiceImpl.class);
    public static final String CACHEND_TRANSACTIONAL_CONTEXT_MAP = "cachendTransactionalContextMap";
    private TransactionalDocumentSafeService transactionalFileStorage;
    private RequestMemoryContext requestContext;

    public CachedTransactionalDocumentSafeServiceImpl(RequestMemoryContext requestContext, TransactionalDocumentSafeService transactionalFileStorage) {
        this.transactionalFileStorage = transactionalFileStorage;
        this.requestContext = requestContext;
    }

    public void createUser(UserIDAuth userIDAuth) {
        this.transactionalFileStorage.createUser(userIDAuth);
    }

    public void destroyUser(UserIDAuth userIDAuth) {
        this.transactionalFileStorage.destroyUser(userIDAuth);
    }

    public boolean userExists(UserID userID) {
        return this.transactionalFileStorage.userExists(userID);
    }

    public void grantAccessToNonTxFolder(UserIDAuth userIDAuth, UserID receiverUserID, DocumentDirectoryFQN documentDirectoryFQN) {
        this.transactionalFileStorage.grantAccessToNonTxFolder(userIDAuth, receiverUserID, documentDirectoryFQN);
    }

    public void nonTxStoreDocument(UserIDAuth userIDAuth, DSDocument dsDocument) {
        this.transactionalFileStorage.nonTxStoreDocument(userIDAuth, dsDocument);
    }

    public void nonTxStoreDocument(UserIDAuth userIDAuth, UserID documentOwner, DSDocument dsDocument) {
        this.transactionalFileStorage.nonTxStoreDocument(userIDAuth, documentOwner, dsDocument);
    }

    public DSDocument nonTxReadDocument(UserIDAuth userIDAuth, UserID documentOwner, DocumentFQN documentFQN) {
        return this.transactionalFileStorage.nonTxReadDocument(userIDAuth, documentOwner, documentFQN);
    }

    public DSDocument nonTxReadDocument(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        return this.transactionalFileStorage.nonTxReadDocument(userIDAuth, documentFQN);
    }

    public boolean nonTxDocumentExists(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        return this.transactionalFileStorage.nonTxDocumentExists(userIDAuth, documentFQN);
    }

    public boolean nonTxDocumentExists(UserIDAuth userIDAuth, UserID documentOwner, DocumentFQN documentFQN) {
        return this.transactionalFileStorage.nonTxDocumentExists(userIDAuth, documentOwner, documentFQN);
    }

    public void nonTxDeleteDocument(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        this.transactionalFileStorage.nonTxDeleteDocument(userIDAuth, documentFQN);
    }

    public BucketContentFQN nonTxListDocuments(UserIDAuth userIDAuth, DocumentDirectoryFQN documentDirectoryFQN, ListRecursiveFlag recursiveFlag) {
        return this.transactionalFileStorage.nonTxListDocuments(userIDAuth, documentDirectoryFQN, recursiveFlag);
    }

    public TxID beginTransaction(UserIDAuth userIDAuth) {
        TxID txid = this.transactionalFileStorage.beginTransaction(userIDAuth);
        this.createTransactionalContext(txid);
        return txid;
    }

    public void txStoreDocument(TxID txid, UserIDAuth userIDAuth, DSDocument dsDocument) {
        this.getTransactionalContext(txid).txStoreDocument(dsDocument);
    }

    public DSDocument txReadDocument(TxID txid, UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        return this.getTransactionalContext(txid).txReadDocument(txid, userIDAuth, documentFQN);
    }

    public void txDeleteDocument(TxID txid, UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        this.getTransactionalContext(txid).txDeleteDocument(documentFQN);
    }

    public BucketContentFQN txListDocuments(TxID txid, UserIDAuth userIDAuth, DocumentDirectoryFQN documentDirectoryFQN, ListRecursiveFlag recursiveFlag) {
        return this.getTransactionalContext(txid).txListDocuments(txid, userIDAuth, documentDirectoryFQN, recursiveFlag);
    }

    public boolean txDocumentExists(TxID txid, UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        return this.getTransactionalContext(txid).txDocumentExists(txid, userIDAuth, documentFQN);
    }

    public void txDeleteFolder(TxID txid, UserIDAuth userIDAuth, DocumentDirectoryFQN documentDirectoryFQN) {
        throw new BaseException("Who needs this interface");
    }

    public void endTransaction(TxID txid, UserIDAuth userIDAuth) {
        this.getTransactionalContext(txid).endTransaction(txid, userIDAuth);
        this.deleteTransactionalContext(txid);
    }

    private CachedTransactionalContext createTransactionalContext(TxID txid) {
        CachedTransactionalContextMap cachedTransactionalContextMap = (CachedTransactionalContextMap)this.requestContext.get((Object)CACHEND_TRANSACTIONAL_CONTEXT_MAP);
        if (cachedTransactionalContextMap == null) {
            cachedTransactionalContextMap = new CachedTransactionalContextMap();
            this.requestContext.put((Object)CACHEND_TRANSACTIONAL_CONTEXT_MAP, (Object)cachedTransactionalContextMap);
        }
        CachedTransactionalContext cachedTransactionalContext = new CachedTransactionalContext(this.transactionalFileStorage);
        cachedTransactionalContextMap.put(txid, cachedTransactionalContext);
        return cachedTransactionalContext;
    }

    private CachedTransactionalContext getTransactionalContext(TxID txid) {
        CachedTransactionalContextMap cachedTransactionalContextMap = (CachedTransactionalContextMap)this.requestContext.get((Object)CACHEND_TRANSACTIONAL_CONTEXT_MAP);
        if (cachedTransactionalContextMap == null) {
            throw new CacheException("RequestContext has no CachedTransactionalContextMap. So Context for " + txid + " can not be searched");
        }
        CachedTransactionalContext cachedTransactionalContext = (CachedTransactionalContext)cachedTransactionalContextMap.get(txid);
        if (cachedTransactionalContext == null) {
            throw new CacheException("CachedTransactionalContextMap has no CachedContext for " + txid);
        }
        return cachedTransactionalContext;
    }

    private void deleteTransactionalContext(TxID txid) {
        CachedTransactionalContextMap cachedTransactionalContextMap = (CachedTransactionalContextMap)this.requestContext.get((Object)CACHEND_TRANSACTIONAL_CONTEXT_MAP);
        if (cachedTransactionalContextMap == null) {
            throw new CacheException("RequestContext has no CachedTransactionalContextMap. So Context for " + txid + " can not be searched");
        }
        CachedTransactionalContext cachedTransactionalContext = (CachedTransactionalContext)cachedTransactionalContextMap.get(txid);
        if (cachedTransactionalContext == null) {
            throw new CacheException("CachedTransactionalContextMap has no CachedContext for " + txid);
        }
        LOGGER.debug("freeMemory() of tx " + txid);
        cachedTransactionalContext.freeMemory();
        cachedTransactionalContextMap.remove(txid);
    }
}

