/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.cached.transactional.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.adorsys.docusafe.business.impl.BucketContentFQNImpl;
import org.adorsys.docusafe.business.types.complex.BucketContentFQN;
import org.adorsys.docusafe.business.types.complex.DSDocument;
import org.adorsys.docusafe.business.types.complex.DocumentDirectoryFQN;
import org.adorsys.docusafe.business.types.complex.DocumentFQN;
import org.adorsys.docusafe.business.types.complex.UserIDAuth;
import org.adorsys.docusafe.cached.transactional.exceptions.CacheException;
import org.adorsys.docusafe.transactional.TransactionalDocumentSafeService;
import org.adorsys.docusafe.transactional.types.TxID;
import org.adorsys.encobject.types.ListRecursiveFlag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CachedTransactionalContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachedTransactionalContext.class);
    private String id = UUID.randomUUID().toString() + " ";
    private Map<DocumentFQN, DSDocument> mapToStore = null;
    private Map<DocumentFQN, DSDocument> mapToRead = null;
    private Set<DocumentFQN> setToDelete = null;
    private TransactionalDocumentSafeService transactionalFileStorage = null;
    private BucketContentFQN bucketContent = null;

    public CachedTransactionalContext(TransactionalDocumentSafeService transactionalFileStorage) {
        this.transactionalFileStorage = transactionalFileStorage;
        this.mapToStore = new HashMap<DocumentFQN, DSDocument>();
        this.mapToRead = new HashMap<DocumentFQN, DSDocument>();
        this.setToDelete = new HashSet<DocumentFQN>();
    }

    public void txStoreDocument(DSDocument dsDocument) {
        this.setToDelete.remove(dsDocument.getDocumentFQN());
        this.mapToStore.put(dsDocument.getDocumentFQN(), dsDocument);
        this.mapToRead.put(dsDocument.getDocumentFQN(), dsDocument);
    }

    public DSDocument txReadDocument(TxID txid, UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        if (this.mapToRead.containsKey(documentFQN)) {
            return this.mapToRead.get(documentFQN);
        }
        if (this.setToDelete.contains(documentFQN)) {
            throw new CacheException("document " + documentFQN + " has been deleted before. can not be read");
        }
        DSDocument dsDocument = this.transactionalFileStorage.txReadDocument(txid, userIDAuth, documentFQN);
        this.mapToRead.put(dsDocument.getDocumentFQN(), dsDocument);
        return dsDocument;
    }

    public void txDeleteDocument(DocumentFQN documentFQN) {
        this.setToDelete.add(documentFQN);
        this.mapToStore.remove(documentFQN);
        this.mapToRead.remove(documentFQN);
    }

    public BucketContentFQN txListDocuments(TxID txid, UserIDAuth userIDAuth, DocumentDirectoryFQN documentDirectoryFQN, ListRecursiveFlag recursiveFlag) {
        if (this.bucketContent == null) {
            this.bucketContent = this.transactionalFileStorage.txListDocuments(txid, userIDAuth, new DocumentDirectoryFQN("/"), ListRecursiveFlag.TRUE);
        }
        BucketContentFQNImpl ret = new BucketContentFQNImpl();
        this.bucketContent.getFiles().forEach(arg_0 -> CachedTransactionalContext.lambda$txListDocuments$0(documentDirectoryFQN, recursiveFlag, (BucketContentFQN)ret, arg_0));
        this.bucketContent.getDirectories().forEach(arg_0 -> CachedTransactionalContext.lambda$txListDocuments$1(documentDirectoryFQN, recursiveFlag, (BucketContentFQN)ret, arg_0));
        ret.getFiles().removeAll(this.setToDelete);
        this.mapToStore.keySet().forEach(arg_0 -> CachedTransactionalContext.lambda$txListDocuments$2(documentDirectoryFQN, (BucketContentFQN)ret, arg_0));
        HashSet allFiles = new HashSet(ret.getFiles());
        ret.getFiles().clear();
        ret.getFiles().addAll(new ArrayList(allFiles));
        return ret;
    }

    public boolean txDocumentExists(TxID txid, UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        if (this.setToDelete.contains(documentFQN)) {
            return false;
        }
        if (this.mapToStore.containsKey(documentFQN)) {
            return true;
        }
        return this.transactionalFileStorage.txDocumentExists(txid, userIDAuth, documentFQN);
    }

    public void endTransaction(TxID txid, UserIDAuth userIDAuth) {
        this.setToDelete.forEach(documentFQN -> this.transactionalFileStorage.txDeleteDocument(txid, userIDAuth, documentFQN));
        this.mapToStore.keySet().forEach(documentFQN -> this.transactionalFileStorage.txStoreDocument(txid, userIDAuth, this.mapToStore.get(documentFQN)));
        this.transactionalFileStorage.endTransaction(txid, userIDAuth);
    }

    public void freeMemory() {
        int numWrite = this.mapToStore.size();
        int numRead = this.mapToRead.size();
        long sumWrite = this.mapToStore.values().stream().mapToLong(dsDocument -> dsDocument.getDocumentContent().getValue().length).sum();
        long sumRead = this.mapToRead.values().stream().mapToLong(dsDocument -> dsDocument.getDocumentContent().getValue().length).sum();
        LOGGER.debug("freeMemory(" + numWrite + ":" + sumWrite + ", " + numRead + ":" + sumRead + ")");
        this.mapToStore.clear();
        this.mapToRead.clear();
        this.setToDelete.clear();
        this.transactionalFileStorage = null;
        this.bucketContent = null;
    }

    private static /* synthetic */ void lambda$txListDocuments$2(DocumentDirectoryFQN documentDirectoryFQN, BucketContentFQN ret, DocumentFQN documentFQN) {
        if (documentFQN.getDocumentDirectory().getValue().startsWith(documentDirectoryFQN.getValue())) {
            ret.getFiles().add(documentFQN);
        }
    }

    private static /* synthetic */ void lambda$txListDocuments$1(DocumentDirectoryFQN documentDirectoryFQN, ListRecursiveFlag recursiveFlag, BucketContentFQN ret, DocumentDirectoryFQN dir) {
        if (dir.getValue().startsWith(documentDirectoryFQN.getValue())) {
            if (recursiveFlag.equals((Object)ListRecursiveFlag.TRUE)) {
                ret.getDirectories().add(dir);
            } else {
                String dirWithoutRoot = dir.getValue().substring(documentDirectoryFQN.getValue().length());
                if (dirWithoutRoot.lastIndexOf("/") == 0) {
                    ret.getDirectories().add(dir);
                }
            }
        }
    }

    private static /* synthetic */ void lambda$txListDocuments$0(DocumentDirectoryFQN documentDirectoryFQN, ListRecursiveFlag recursiveFlag, BucketContentFQN ret, DocumentFQN file) {
        if (file.getValue().startsWith(documentDirectoryFQN.getValue())) {
            if (recursiveFlag.equals((Object)ListRecursiveFlag.TRUE)) {
                ret.getFiles().add(file);
            } else {
                String fileWithoutRoot = file.getValue().substring(documentDirectoryFQN.getValue().length());
                if (fileWithoutRoot.lastIndexOf("/") == 0) {
                    ret.getFiles().add(file);
                }
            }
        }
    }
}

