/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.docusafe.business.types;

import de.adorsys.dfs.connection.api.filesystem.FilesystemConnectionPropertiesImpl;
import de.adorsys.dfs.connection.api.types.connection.AmazonS3RootBucketName;
import de.adorsys.dfs.connection.api.types.connection.FilesystemRootBucketName;
import de.adorsys.dfs.connection.api.types.properties.AmazonS3ConnectionProperties;
import de.adorsys.dfs.connection.api.types.properties.ConnectionProperties;
import de.adorsys.dfs.connection.api.types.properties.FilesystemConnectionProperties;
import de.adorsys.dfs.connection.impl.amazons3.AmazonS3ConnectionProperitesImpl;

public class DFSCredentials {
    private FilesystemConnectionPropertiesImpl filesystem = null;
    private AmazonS3ConnectionProperitesImpl amazons3 = null;

    public DFSCredentials(DFSCredentials dfsCredentials) {
        if (dfsCredentials.filesystem != null) {
            this.filesystem = new FilesystemConnectionPropertiesImpl((FilesystemConnectionProperties)dfsCredentials.filesystem);
        }
        if (dfsCredentials.amazons3 != null) {
            this.amazons3 = new AmazonS3ConnectionProperitesImpl((AmazonS3ConnectionProperties)dfsCredentials.amazons3);
        }
    }

    public DFSCredentials(ConnectionProperties props) {
        if (props instanceof FilesystemConnectionPropertiesImpl) {
            this.setFilesystem(new FilesystemConnectionPropertiesImpl((FilesystemConnectionProperties)((FilesystemConnectionPropertiesImpl)props)));
        } else {
            this.setAmazons3(new AmazonS3ConnectionProperitesImpl((AmazonS3ConnectionProperties)((AmazonS3ConnectionProperitesImpl)props)));
        }
    }

    public void addRootBucket(TYPE type) {
        this.addSubDirToRoot(type.toString());
    }

    public void addSubDirToRoot(String subdir) {
        String root;
        if (this.getFilesystem() != null) {
            root = this.getFilesystem().getFilesystemRootBucketName().getValue();
            root = root + "/" + subdir;
            this.getFilesystem().setFilesystemRootBucketName(new FilesystemRootBucketName(root));
        }
        if (this.getAmazons3() != null) {
            root = this.getAmazons3().getAmazonS3RootBucketName().getValue();
            root = root + "/" + subdir;
            this.getAmazons3().setAmazonS3RootBucketName(new AmazonS3RootBucketName(root));
        }
    }

    public ConnectionProperties getProperties() {
        if (this.filesystem != null) {
            return this.filesystem;
        }
        return this.amazons3;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DFSCredentials{");
        if (this.filesystem != null) {
            sb.append(" FilesystemRootBucketName:" + this.filesystem.getFilesystemRootBucketName());
        }
        if (this.amazons3 != null) {
            sb.append(" AmazonS3RootBucketName:" + this.amazons3.getAmazonS3RootBucketName());
            sb.append(" url:" + this.amazons3.getUrl().toString());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DFSCredentials)) {
            return false;
        }
        DFSCredentials other = (DFSCredentials)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FilesystemConnectionPropertiesImpl this$filesystem = this.getFilesystem();
        FilesystemConnectionPropertiesImpl other$filesystem = other.getFilesystem();
        if (this$filesystem == null ? other$filesystem != null : !this$filesystem.equals(other$filesystem)) {
            return false;
        }
        AmazonS3ConnectionProperitesImpl this$amazons3 = this.getAmazons3();
        AmazonS3ConnectionProperitesImpl other$amazons3 = other.getAmazons3();
        return !(this$amazons3 == null ? other$amazons3 != null : !this$amazons3.equals(other$amazons3));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DFSCredentials;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FilesystemConnectionPropertiesImpl $filesystem = this.getFilesystem();
        result = result * 59 + ($filesystem == null ? 43 : $filesystem.hashCode());
        AmazonS3ConnectionProperitesImpl $amazons3 = this.getAmazons3();
        result = result * 59 + ($amazons3 == null ? 43 : $amazons3.hashCode());
        return result;
    }

    public FilesystemConnectionPropertiesImpl getFilesystem() {
        return this.filesystem;
    }

    public AmazonS3ConnectionProperitesImpl getAmazons3() {
        return this.amazons3;
    }

    public void setFilesystem(FilesystemConnectionPropertiesImpl filesystem) {
        this.filesystem = filesystem;
    }

    public void setAmazons3(AmazonS3ConnectionProperitesImpl amazons3) {
        this.amazons3 = amazons3;
    }

    public static enum TYPE {
        USERS_DFS,
        SYSTEM_DFS;

    }
}

