/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.business.types.complex;

import org.adorsys.cryptoutils.basetypes.BaseTypeString;
import org.adorsys.cryptoutils.exceptions.BaseException;
import org.adorsys.docusafe.business.types.complex.DocumentDirectoryFQN;

public class DocumentFQN
extends BaseTypeString {
    public DocumentFQN(String value) {
        super(DocumentFQN.check(DocumentFQN.prependStartingSeparator(value)));
    }

    public DocumentDirectoryFQN getDocumentDirectory() {
        String value = this.getValue();
        int lastIndex = value.lastIndexOf("/");
        return new DocumentDirectoryFQN(value.substring(0, lastIndex));
    }

    public DocumentFQN getPlainNameWithoutPath() {
        String fqn = this.getValue();
        return new DocumentFQN(fqn.substring(fqn.lastIndexOf("/")));
    }

    private static String prependStartingSeparator(String s) {
        if (s.startsWith("/")) {
            return s;
        }
        return "/" + s;
    }

    public static String check(String s) {
        if (s.length() > 1 && s.endsWith("/")) {
            throw new BaseException(s + " must not end with a slash");
        }
        if (s.contains("//")) {
            throw new BaseException(s + " must not contain dobule slashes");
        }
        return s;
    }
}

