/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.business.impl;

import com.nimbusds.jose.jwk.JWK;
import java.security.UnrecoverableEntryException;
import org.adorsys.cryptoutils.exceptions.BaseException;
import org.adorsys.cryptoutils.exceptions.BaseExceptionHandler;
import org.adorsys.docusafe.business.DocumentSafeService;
import org.adorsys.docusafe.business.exceptions.NoReadAccessException;
import org.adorsys.docusafe.business.exceptions.NoWriteAccessException;
import org.adorsys.docusafe.business.exceptions.UserIDAlreadyExistsException;
import org.adorsys.docusafe.business.exceptions.UserIDDoesNotExistException;
import org.adorsys.docusafe.business.exceptions.WrongPasswordException;
import org.adorsys.docusafe.business.impl.BucketContentFQNImpl;
import org.adorsys.docusafe.business.impl.CacheType;
import org.adorsys.docusafe.business.impl.DocusafeCacheWrapper;
import org.adorsys.docusafe.business.impl.DocusafeCacheWrapperImpl;
import org.adorsys.docusafe.business.impl.WithCache;
import org.adorsys.docusafe.business.impl.caches.DocumentGuardCache;
import org.adorsys.docusafe.business.impl.caches.DocumentKeyIDCache;
import org.adorsys.docusafe.business.impl.caches.UserAuthCache;
import org.adorsys.docusafe.business.types.UserID;
import org.adorsys.docusafe.business.types.complex.BucketContentFQN;
import org.adorsys.docusafe.business.types.complex.DSDocument;
import org.adorsys.docusafe.business.types.complex.DSDocumentMetaInfo;
import org.adorsys.docusafe.business.types.complex.DSDocumentStream;
import org.adorsys.docusafe.business.types.complex.DocumentDirectoryFQN;
import org.adorsys.docusafe.business.types.complex.DocumentFQN;
import org.adorsys.docusafe.business.types.complex.UserIDAuth;
import org.adorsys.docusafe.business.utils.BucketPath2FQNHelper;
import org.adorsys.docusafe.business.utils.GrantUtil;
import org.adorsys.docusafe.business.utils.GuardUtil;
import org.adorsys.docusafe.business.utils.UserIDUtil;
import org.adorsys.docusafe.service.BucketService;
import org.adorsys.docusafe.service.DocumentGuardService;
import org.adorsys.docusafe.service.DocumentPersistenceService;
import org.adorsys.docusafe.service.KeySourceService;
import org.adorsys.docusafe.service.impl.BucketServiceImpl;
import org.adorsys.docusafe.service.impl.DocumentGuardServiceImpl;
import org.adorsys.docusafe.service.impl.DocumentKeyID2DocumentKeyCache;
import org.adorsys.docusafe.service.impl.DocumentPersistenceServiceImpl;
import org.adorsys.docusafe.service.impl.GuardKeyType;
import org.adorsys.docusafe.service.impl.KeySourceServiceImpl;
import org.adorsys.docusafe.service.impl.PasswordAndDocumentKeyIDWithKeyAndAccessType;
import org.adorsys.docusafe.service.types.AccessType;
import org.adorsys.docusafe.service.types.BucketContent;
import org.adorsys.docusafe.service.types.DocumentContent;
import org.adorsys.docusafe.service.types.DocumentKeyID;
import org.adorsys.docusafe.service.types.complextypes.DocumentBucketPath;
import org.adorsys.docusafe.service.types.complextypes.DocumentGuardLocation;
import org.adorsys.docusafe.service.types.complextypes.DocumentKeyIDWithKeyAndAccessType;
import org.adorsys.encobject.complextypes.BucketDirectory;
import org.adorsys.encobject.complextypes.BucketPath;
import org.adorsys.encobject.domain.KeyStoreAccess;
import org.adorsys.encobject.domain.KeyStoreAuth;
import org.adorsys.encobject.domain.Payload;
import org.adorsys.encobject.domain.PayloadStream;
import org.adorsys.encobject.domain.ReadKeyPassword;
import org.adorsys.encobject.domain.StorageMetadata;
import org.adorsys.encobject.domain.UserMetaData;
import org.adorsys.encobject.service.api.ExtendedStoreConnection;
import org.adorsys.encobject.service.api.KeyStoreService;
import org.adorsys.encobject.service.impl.KeyStoreServiceImpl;
import org.adorsys.encobject.service.impl.SimplePayloadImpl;
import org.adorsys.encobject.service.impl.SimplePayloadStreamImpl;
import org.adorsys.encobject.service.impl.SimpleStorageMetadataImpl;
import org.adorsys.encobject.types.ListRecursiveFlag;
import org.adorsys.encobject.types.OverwriteFlag;
import org.adorsys.jkeygen.keystore.KeyStoreType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentSafeServiceImpl
implements DocumentSafeService,
DocumentKeyID2DocumentKeyCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentSafeServiceImpl.class);
    public static final String USER_AUTH_CACHE = "userAuthCache";
    public static final String GUARD_MAP = "GUARD_MAP";
    public static final String DOCUMENT_KEY_MAP = "DOCUMENT_KEY_MAP";
    private BucketService bucketService;
    private KeyStoreService keyStoreService;
    private DocumentGuardService documentGuardService;
    private DocumentPersistenceService documentPersistenceService;
    private KeySourceService keySourceService;
    private ExtendedStoreConnection extendedStoreConnection;
    private DocusafeCacheWrapper docusafeCacheWrapper = null;

    public DocumentSafeServiceImpl(WithCache withCache, ExtendedStoreConnection extendedStoreConnection) {
        this.extendedStoreConnection = extendedStoreConnection;
        this.bucketService = new BucketServiceImpl(extendedStoreConnection);
        this.keyStoreService = new KeyStoreServiceImpl(extendedStoreConnection);
        this.documentGuardService = new DocumentGuardServiceImpl(extendedStoreConnection);
        this.documentPersistenceService = new DocumentPersistenceServiceImpl(extendedStoreConnection, (DocumentKeyID2DocumentKeyCache)this);
        this.keySourceService = new KeySourceServiceImpl(extendedStoreConnection);
        if (withCache.equals((Object)WithCache.TRUE)) {
            this.docusafeCacheWrapper = new DocusafeCacheWrapperImpl(CacheType.GUAVA);
        }
        if (withCache.equals((Object)WithCache.TRUE_HASH_MAP)) {
            this.docusafeCacheWrapper = new DocusafeCacheWrapperImpl(CacheType.HASH_MAP);
        }
    }

    @Override
    public void createUser(UserIDAuth userIDAuth) {
        LOGGER.debug("start create user for " + userIDAuth);
        if (this.userExists(userIDAuth.getUserID())) {
            throw new UserIDAlreadyExistsException(userIDAuth.getUserID().toString());
        }
        KeyStoreAccess keyStoreAccess = null;
        BucketDirectory keyStoreDirectory = UserIDUtil.getKeyStoreDirectory(userIDAuth.getUserID());
        KeyStoreAuth keyStoreAuth = UserIDUtil.getKeyStoreAuth(userIDAuth);
        this.bucketService.createBucket(keyStoreDirectory);
        BucketPath keyStorePath = UserIDUtil.getKeyStorePath(userIDAuth.getUserID());
        this.keyStoreService.createKeyStore(keyStoreAuth, KeyStoreType.DEFAULT, keyStorePath, null);
        keyStoreAccess = new KeyStoreAccess(keyStorePath, keyStoreAuth);
        BucketDirectory userHomeBucketDirectory = UserIDUtil.getHomeBucketDirectory(userIDAuth.getUserID());
        this.bucketService.createBucket(userHomeBucketDirectory);
        this.createSymmetricGuardForBucket(keyStoreAccess, userHomeBucketDirectory, AccessType.WRITE);
        this.storeDocument(userIDAuth, this.createWelcomeDocument());
        LOGGER.debug("finished create user for " + userIDAuth);
    }

    @Override
    public void destroyUser(UserIDAuth userIDAuth) {
        LOGGER.debug("start destroy user for " + userIDAuth);
        BucketDirectory userRootBucketDirectory = UserIDUtil.getUserRootBucketDirectory(userIDAuth.getUserID());
        if (!this.bucketService.bucketExists(userRootBucketDirectory)) {
            throw new UserIDDoesNotExistException(userIDAuth.getUserID());
        }
        this.checkUserKeyPassword(userIDAuth);
        this.bucketService.destroyBucket(userRootBucketDirectory);
        LOGGER.debug("finished destroy user for " + userIDAuth);
    }

    @Override
    public boolean userExists(UserID userID) {
        BucketDirectory userRootBucketDirectory = UserIDUtil.getUserRootBucketDirectory(userID);
        return this.bucketService.bucketExists(userRootBucketDirectory);
    }

    @Override
    public void storeDocument(UserIDAuth userIDAuth, DSDocument dsDocument) {
        LOGGER.debug("start storeDocument for " + userIDAuth + " " + (Object)((Object)dsDocument.getDocumentFQN()));
        SimpleStorageMetadataImpl storageMetadata = new SimpleStorageMetadataImpl();
        storageMetadata.mergeUserMetadata((UserMetaData)dsDocument.getDsDocumentMetaInfo());
        storageMetadata.setSize(new Long(dsDocument.getDocumentContent().getValue().length));
        DocumentBucketPath documentBucketPath = this.getTheDocumentBucketPath(userIDAuth.getUserID(), dsDocument.getDocumentFQN());
        DocumentKeyIDWithKeyAndAccessType documentKeyIDWithKeyAndAccessType = this.getOrCreateDocumentKeyIDwithKeyForBucketPath(userIDAuth, documentBucketPath.getBucketDirectory(), AccessType.WRITE);
        if (dsDocument.getDsDocumentMetaInfo().isNotEncrypted()) {
            this.documentPersistenceService.persistDocument(documentBucketPath, OverwriteFlag.TRUE, (Payload)new SimplePayloadImpl((StorageMetadata)storageMetadata, dsDocument.getDocumentContent().getValue()));
            LOGGER.debug("finished storeDocument unencrypted document for " + userIDAuth + " " + (Object)((Object)dsDocument.getDocumentFQN()));
            return;
        }
        this.documentPersistenceService.encryptAndPersistDocument(documentKeyIDWithKeyAndAccessType.getDocumentKeyIDWithKey(), documentBucketPath, OverwriteFlag.TRUE, (Payload)new SimplePayloadImpl((StorageMetadata)storageMetadata, dsDocument.getDocumentContent().getValue()));
        LOGGER.debug("finished storeDocument encrypted document for " + userIDAuth + " " + (Object)((Object)dsDocument.getDocumentFQN()));
    }

    @Override
    public DSDocument readDocument(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        LOGGER.debug("start readDocument for " + userIDAuth + " " + (Object)((Object)documentFQN));
        DocumentBucketPath documentBucketPath = this.getTheDocumentBucketPath(userIDAuth.getUserID(), documentFQN);
        StorageMetadata storageMetadata = this.extendedStoreConnection.getStorageMetadata((BucketPath)documentBucketPath);
        if (DocumentPersistenceService.isNotEncrypted((UserMetaData)storageMetadata.getUserMetadata())) {
            this.checkUserKeyPassword(userIDAuth);
            Payload payload = this.documentPersistenceService.loadDocument(storageMetadata, documentBucketPath);
            DSDocument dsDocument = new DSDocument(documentFQN, new DocumentContent(payload.getData()), new DSDocumentMetaInfo(payload.getStorageMetadata().getUserMetadata()));
            LOGGER.debug("finished readDocument for " + userIDAuth + " " + (Object)((Object)documentFQN));
            return dsDocument;
        }
        KeyStoreAccess keyStoreAccess = this.getKeyStoreAccess(userIDAuth);
        Payload payload = this.documentPersistenceService.loadAndDecryptDocument(storageMetadata, keyStoreAccess, documentBucketPath);
        LOGGER.debug("finished readDocument for " + userIDAuth + " " + (Object)((Object)documentFQN));
        DSDocument dsDocument = new DSDocument(documentFQN, new DocumentContent(payload.getData()), new DSDocumentMetaInfo(payload.getStorageMetadata().getUserMetadata()));
        if (dsDocument.getDsDocumentMetaInfo().isNotEncrypted()) {
            this.checkUserKeyPassword(userIDAuth);
        }
        return dsDocument;
    }

    @Override
    public void storeDocumentStream(UserIDAuth userIDAuth, DSDocumentStream dsDocumentStream) {
        LOGGER.debug("start storeDocumentStream for " + userIDAuth + " " + (Object)((Object)dsDocumentStream.getDocumentFQN()));
        SimpleStorageMetadataImpl storageMetadata = new SimpleStorageMetadataImpl();
        storageMetadata.mergeUserMetadata((UserMetaData)dsDocumentStream.getDsDocumentMetaInfo());
        DocumentBucketPath documentBucketPath = this.getTheDocumentBucketPath(userIDAuth.getUserID(), dsDocumentStream.getDocumentFQN());
        DocumentKeyIDWithKeyAndAccessType documentKeyIDWithKeyAndAccessType = this.getOrCreateDocumentKeyIDwithKeyForBucketPath(userIDAuth, documentBucketPath.getBucketDirectory(), AccessType.WRITE);
        if (dsDocumentStream.getDsDocumentMetaInfo().isNotEncrypted()) {
            this.documentPersistenceService.persistDocumentStream(documentBucketPath, OverwriteFlag.TRUE, (PayloadStream)new SimplePayloadStreamImpl((StorageMetadata)storageMetadata, dsDocumentStream.getDocumentStream()));
            LOGGER.debug("finished store and unencrypted document stream for " + userIDAuth + " " + (Object)((Object)dsDocumentStream.getDocumentFQN()));
            return;
        }
        this.documentPersistenceService.encryptAndPersistDocumentStream(documentKeyIDWithKeyAndAccessType.getDocumentKeyIDWithKey(), documentBucketPath, OverwriteFlag.TRUE, (PayloadStream)new SimplePayloadStreamImpl((StorageMetadata)storageMetadata, dsDocumentStream.getDocumentStream()));
        LOGGER.debug("finished storeDocument encrypted document stream for " + userIDAuth + " " + (Object)((Object)dsDocumentStream.getDocumentFQN()));
    }

    @Override
    public DSDocumentStream readDocumentStream(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        try {
            LOGGER.debug("start readDocumentStream for " + userIDAuth + " " + (Object)((Object)documentFQN));
            DocumentBucketPath documentBucketPath = this.getTheDocumentBucketPath(userIDAuth.getUserID(), documentFQN);
            StorageMetadata storageMetadata = this.extendedStoreConnection.getStorageMetadata((BucketPath)documentBucketPath);
            if (DocumentPersistenceService.isNotEncrypted((UserMetaData)storageMetadata.getUserMetadata())) {
                this.checkUserKeyPassword(userIDAuth);
                PayloadStream payloadStream = this.documentPersistenceService.loadDocumentStream(storageMetadata, documentBucketPath);
                DSDocumentStream dsDocumentStream = new DSDocumentStream(documentFQN, payloadStream.openStream(), new DSDocumentMetaInfo(payloadStream.getStorageMetadata().getUserMetadata()));
                LOGGER.debug("finished readDocumentStream for " + userIDAuth + " " + (Object)((Object)documentFQN));
                return dsDocumentStream;
            }
            KeyStoreAccess keyStoreAccess = this.getKeyStoreAccess(userIDAuth);
            PayloadStream payloadStream = this.documentPersistenceService.loadAndDecryptDocumentStream(storageMetadata, keyStoreAccess, documentBucketPath);
            LOGGER.debug("finished read and decrypt DocumentStream for " + userIDAuth + " " + (Object)((Object)documentFQN));
            DSDocumentStream dsDocumentStream = new DSDocumentStream(documentFQN, payloadStream.openStream(), new DSDocumentMetaInfo(payloadStream.getStorageMetadata().getUserMetadata()));
            return dsDocumentStream;
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    @Override
    public void deleteDocument(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        this.checkUserKeyPassword(userIDAuth);
        DocumentBucketPath documentBucketPath = this.getTheDocumentBucketPath(userIDAuth.getUserID(), documentFQN);
        this.bucketService.deletePlainFile((BucketPath)documentBucketPath);
    }

    @Override
    public boolean documentExists(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        this.checkUserKeyPassword(userIDAuth);
        DocumentBucketPath documentBucketPath = this.getTheDocumentBucketPath(userIDAuth.getUserID(), documentFQN);
        return this.bucketService.fileExists((BucketPath)documentBucketPath);
    }

    @Override
    public void deleteFolder(UserIDAuth userIDAuth, DocumentDirectoryFQN documentDirectoryFQN) {
        BucketDirectory homeBucketDirectory = UserIDUtil.getHomeBucketDirectory(userIDAuth.getUserID());
        BucketDirectory documentBucketDirectory = homeBucketDirectory.append(new BucketDirectory(documentDirectoryFQN.getValue()));
        this.bucketService.deletePlainFolder(documentBucketDirectory);
    }

    @Override
    public BucketContentFQN list(UserIDAuth userIDAuth, DocumentDirectoryFQN documentDirectoryFQN, ListRecursiveFlag recursiveFlag) {
        LOGGER.debug("list directroy " + (Object)((Object)documentDirectoryFQN) + " for " + (Object)((Object)userIDAuth.getUserID()));
        this.checkUserKeyPassword(userIDAuth);
        BucketDirectory homeBucketDirectory = UserIDUtil.getHomeBucketDirectory(userIDAuth.getUserID());
        BucketDirectory bucketDirectory = documentDirectoryFQN.prepend(homeBucketDirectory);
        BucketContentFQNImpl ret = new BucketContentFQNImpl();
        BucketContent bucketContent = this.bucketService.readDocumentBucket(bucketDirectory, recursiveFlag);
        bucketContent.getFiles().forEach(bucketPath -> ret.getFiles().add(BucketPath2FQNHelper.path2FQN(homeBucketDirectory, bucketPath)));
        DocumentDirectoryFQN dir = documentDirectoryFQN.getValue().startsWith("/") ? documentDirectoryFQN : new DocumentDirectoryFQN("/" + documentDirectoryFQN.getValue());
        bucketContent.getSubdirectories().forEach(subdirectory -> {
            DocumentDirectoryFQN dirFQN = BucketPath2FQNHelper.directory2FQN(homeBucketDirectory, subdirectory);
            if (!dirFQN.equals((Object)dir)) {
                ret.getDirectories().add(dirFQN);
            }
        });
        return ret;
    }

    @Override
    public void grantAccessToUserForFolder(UserIDAuth userIDAuth, UserID receiverUserID, DocumentDirectoryFQN documentDirectoryFQN, AccessType accessType) {
        LOGGER.debug("start grant access for " + userIDAuth + " to  " + (Object)((Object)receiverUserID) + " for " + (Object)((Object)documentDirectoryFQN) + " with " + accessType);
        BucketDirectory userRootBucketDirectory = UserIDUtil.getUserRootBucketDirectory(userIDAuth.getUserID());
        if (!this.bucketService.bucketExists(userRootBucketDirectory)) {
            throw new UserIDDoesNotExistException(userIDAuth.getUserID());
        }
        userRootBucketDirectory = UserIDUtil.getUserRootBucketDirectory(receiverUserID);
        if (!this.bucketService.bucketExists(userRootBucketDirectory)) {
            throw new UserIDDoesNotExistException(receiverUserID);
        }
        BucketDirectory homeBucketDirectory = UserIDUtil.getHomeBucketDirectory(userIDAuth.getUserID());
        BucketDirectory documentBucketDirectory = homeBucketDirectory.append(new BucketDirectory(documentDirectoryFQN.getValue()));
        AccessType grantedAccess = GrantUtil.getAccessTypeOfBucketGrantFile(this.bucketService, documentBucketDirectory, userIDAuth.getUserID(), receiverUserID);
        if (grantedAccess.equals((Object)accessType)) {
            LOGGER.debug("nothing to do. granted access already exists for " + userIDAuth + " to  " + (Object)((Object)receiverUserID) + " for " + (Object)((Object)documentDirectoryFQN) + " with " + accessType);
            return;
        }
        if (!grantedAccess.equals((Object)AccessType.NONE)) {
            LOGGER.debug("granted access for " + userIDAuth + " to  " + (Object)((Object)receiverUserID) + " for " + (Object)((Object)documentDirectoryFQN) + " will be changed from " + grantedAccess + " to " + accessType);
        }
        DocumentKeyIDWithKeyAndAccessType usersDocumentKeyIDWithKeyAndAccessType = this.getOrCreateDocumentKeyIDwithKeyForBucketPath(userIDAuth, documentBucketDirectory, AccessType.WRITE);
        DocumentKeyIDWithKeyAndAccessType receiversDocumentKeyWithIDAndAccessType = new DocumentKeyIDWithKeyAndAccessType(usersDocumentKeyIDWithKeyAndAccessType.getDocumentKeyIDWithKey(), accessType);
        UserIDAuth receiverUserIDAuth = new UserIDAuth(receiverUserID, null);
        KeyStoreAccess receiverKeyStoreAccess = this.getKeyStoreAccess(receiverUserIDAuth);
        if (AccessType.NONE.equals((Object)accessType)) {
            this.deleteGuardForBucket(receiverKeyStoreAccess, receiversDocumentKeyWithIDAndAccessType, documentBucketDirectory);
            this.deleteCacheKey(receiverKeyStoreAccess, receiversDocumentKeyWithIDAndAccessType.getDocumentKeyIDWithKey().getDocumentKeyID());
        } else {
            this.createAsymmetricGuardForBucket(receiverKeyStoreAccess, receiversDocumentKeyWithIDAndAccessType, documentBucketDirectory, OverwriteFlag.TRUE);
        }
        GrantUtil.saveBucketGrantFile(this.bucketService, documentBucketDirectory, userIDAuth.getUserID(), receiverUserID, accessType);
        LOGGER.debug("finished grant access for " + userIDAuth + " to  " + (Object)((Object)receiverUserID) + " for " + (Object)((Object)documentDirectoryFQN) + " with " + accessType);
    }

    @Override
    public void storeGrantedDocument(UserIDAuth userIDAuth, UserID documentOwner, DSDocument dsDocument) {
        LOGGER.debug("start storeDocument for " + userIDAuth + " " + (Object)((Object)documentOwner) + " " + (Object)((Object)dsDocument.getDocumentFQN()));
        SimpleStorageMetadataImpl storageMetadata = new SimpleStorageMetadataImpl();
        storageMetadata.mergeUserMetadata((UserMetaData)dsDocument.getDsDocumentMetaInfo());
        DocumentBucketPath documentBucketPath = this.getTheDocumentBucketPath(documentOwner, dsDocument.getDocumentFQN());
        DocumentKeyIDWithKeyAndAccessType documentKeyIDWithKeyAndAccessType = this.getDocumentKeyIDwithKeyForBucketPath(userIDAuth, documentBucketPath.getBucketDirectory());
        if (!documentKeyIDWithKeyAndAccessType.getAccessType().equals((Object)AccessType.WRITE)) {
            throw new NoWriteAccessException(userIDAuth.getUserID(), documentOwner, dsDocument.getDocumentFQN());
        }
        if (dsDocument.getDsDocumentMetaInfo().isNotEncrypted()) {
            this.documentPersistenceService.persistDocument(documentBucketPath, OverwriteFlag.TRUE, (Payload)new SimplePayloadImpl((StorageMetadata)storageMetadata, dsDocument.getDocumentContent().getValue()));
            LOGGER.debug("finished storeDocument unencrypted document for " + userIDAuth + " " + (Object)((Object)dsDocument.getDocumentFQN()));
            return;
        }
        this.documentPersistenceService.encryptAndPersistDocument(documentKeyIDWithKeyAndAccessType.getDocumentKeyIDWithKey(), documentBucketPath, OverwriteFlag.TRUE, (Payload)new SimplePayloadImpl((StorageMetadata)storageMetadata, dsDocument.getDocumentContent().getValue()));
        LOGGER.debug("finished storeDocument encrypted for " + userIDAuth + " " + (Object)((Object)documentOwner) + " " + (Object)((Object)dsDocument.getDocumentFQN()));
    }

    @Override
    public DSDocument readGrantedDocument(UserIDAuth userIDAuth, UserID documentOwner, DocumentFQN documentFQN) {
        LOGGER.debug("start readDocument for " + userIDAuth + " " + (Object)((Object)documentOwner) + " " + (Object)((Object)documentFQN));
        DocumentBucketPath documentBucketPath = this.getTheDocumentBucketPath(documentOwner, documentFQN);
        StorageMetadata storageMetadata = this.extendedStoreConnection.getStorageMetadata((BucketPath)documentBucketPath);
        if (DocumentPersistenceService.isNotEncrypted((UserMetaData)storageMetadata.getUserMetadata())) {
            this.checkUserKeyPassword(userIDAuth);
            DocumentKeyIDWithKeyAndAccessType documentKeyIDWithKeyAndAccessType = this.getDocumentKeyIDwithKeyForBucketPath(userIDAuth, documentBucketPath.getBucketDirectory());
            if (documentKeyIDWithKeyAndAccessType.getAccessType().equals((Object)AccessType.NONE)) {
                throw new NoReadAccessException(userIDAuth.getUserID(), documentOwner, documentFQN);
            }
            Payload payload = this.documentPersistenceService.loadDocument(storageMetadata, documentBucketPath);
            DSDocument dsDocument = new DSDocument(documentFQN, new DocumentContent(payload.getData()), new DSDocumentMetaInfo(payload.getStorageMetadata().getUserMetadata()));
            LOGGER.debug("finisherd readDocument for " + userIDAuth + " " + (Object)((Object)documentOwner) + " " + (Object)((Object)documentFQN));
            return dsDocument;
        }
        KeyStoreAccess keyStoreAccess = this.getKeyStoreAccess(userIDAuth);
        Payload payload = this.documentPersistenceService.loadAndDecryptDocument(storageMetadata, keyStoreAccess, documentBucketPath);
        LOGGER.debug("finisherd read and decrypt Document for " + userIDAuth + " " + (Object)((Object)documentOwner) + " " + (Object)((Object)documentFQN));
        return new DSDocument(documentFQN, new DocumentContent(payload.getData()), new DSDocumentMetaInfo(payload.getStorageMetadata().getUserMetadata()));
    }

    @Override
    public boolean grantedDocumentExists(UserIDAuth userIDAuth, UserID documentOwner, DocumentFQN documentFQN) {
        LOGGER.debug("start grantedDocumentExists for " + userIDAuth + " " + (Object)((Object)documentOwner) + " " + (Object)((Object)documentFQN));
        DocumentBucketPath documentBucketPath = this.getTheDocumentBucketPath(documentOwner, documentFQN);
        this.checkUserKeyPassword(userIDAuth);
        return this.bucketService.fileExists((BucketPath)documentBucketPath);
    }

    @Override
    public JWK findPublicEncryptionKey(UserID userID) {
        KeyStoreAccess keyStoreAccess = this.getKeyStoreAccess(new UserIDAuth(userID, null));
        return this.keySourceService.findPublicEncryptionKey(keyStoreAccess);
    }

    private DocumentKeyID createSymmetricGuardForBucket(KeyStoreAccess keyStoreAccess, BucketDirectory documentDirectory, AccessType accessType) {
        LOGGER.debug("start create new guard for " + documentDirectory);
        DocumentKeyIDWithKeyAndAccessType documentKeyIDWithKeyAndAccessType = new DocumentKeyIDWithKeyAndAccessType(this.documentGuardService.createDocumentKeyIdWithKey(), accessType);
        this.createCachedDocumentGuardFor(GuardKeyType.SECRET_KEY, keyStoreAccess, documentKeyIDWithKeyAndAccessType, OverwriteFlag.FALSE);
        GuardUtil.saveBucketGuardKeyFile(this.bucketService, keyStoreAccess.getKeyStorePath().getBucketDirectory(), documentDirectory, documentKeyIDWithKeyAndAccessType.getDocumentKeyIDWithKey().getDocumentKeyID());
        LOGGER.debug("finished create new guard for " + documentDirectory);
        return documentKeyIDWithKeyAndAccessType.getDocumentKeyIDWithKey().getDocumentKeyID();
    }

    private DocumentKeyID createAsymmetricGuardForBucket(KeyStoreAccess keyStoreAccess, DocumentKeyIDWithKeyAndAccessType documentKeyIDWithKeyAndAccessType, BucketDirectory documentDirectory, OverwriteFlag overwriteFlag) {
        LOGGER.debug("start create asymmetric guard for " + documentDirectory + " " + keyStoreAccess.getKeyStorePath().getBucketDirectory());
        this.createCachedDocumentGuardFor(GuardKeyType.PUBLIC_KEY, keyStoreAccess, documentKeyIDWithKeyAndAccessType, overwriteFlag);
        GuardUtil.saveBucketGuardKeyFile(this.bucketService, keyStoreAccess.getKeyStorePath().getBucketDirectory(), documentDirectory, documentKeyIDWithKeyAndAccessType.getDocumentKeyIDWithKey().getDocumentKeyID());
        LOGGER.debug("finished create asymmetric guard for " + documentDirectory + " " + keyStoreAccess.getKeyStorePath().getBucketDirectory());
        return documentKeyIDWithKeyAndAccessType.getDocumentKeyIDWithKey().getDocumentKeyID();
    }

    private void deleteGuardForBucket(KeyStoreAccess keyStoreAccess, DocumentKeyIDWithKeyAndAccessType documentKeyIDWithKeyAndAccessType, BucketDirectory documentDirectory) {
        LOGGER.debug("start delete guard for " + documentDirectory);
        BucketPath documentGuardFileBucketPath = DocumentGuardLocation.getBucketPathOfGuard((BucketPath)keyStoreAccess.getKeyStorePath(), (DocumentKeyID)documentKeyIDWithKeyAndAccessType.getDocumentKeyIDWithKey().getDocumentKeyID());
        this.bucketService.deletePlainFile(documentGuardFileBucketPath);
        GuardUtil.deleteBucketGuardKeyFile(this.bucketService, keyStoreAccess.getKeyStorePath().getBucketDirectory(), documentDirectory);
        LOGGER.debug("finished delete guard for " + documentDirectory);
    }

    private KeyStoreAccess getKeyStoreAccess(UserIDAuth userIDAuth) {
        BucketPath keyStorePath = UserIDUtil.getKeyStorePath(userIDAuth.getUserID());
        KeyStoreAuth keyStoreAuth = UserIDUtil.getKeyStoreAuth(userIDAuth);
        KeyStoreAccess keyStoreAccess = new KeyStoreAccess(keyStorePath, keyStoreAuth);
        return keyStoreAccess;
    }

    private DocumentBucketPath getTheDocumentBucketPath(UserID userID, DocumentFQN documentFQN) {
        return new DocumentBucketPath(UserIDUtil.getHomeBucketDirectory(userID).appendName(documentFQN.getValue()));
    }

    private DSDocument createWelcomeDocument() {
        String text = "Welcome to the DocumentStore";
        DocumentContent documentContent = new DocumentContent(text.getBytes());
        DocumentFQN documentFQN = new DocumentFQN("README.txt");
        DSDocument dsDocument = new DSDocument(documentFQN, documentContent, null);
        return dsDocument;
    }

    private DocumentKeyIDWithKeyAndAccessType getOrCreateDocumentKeyIDwithKeyForBucketPath(UserIDAuth userIDAuth, BucketDirectory documentDirectory, AccessType accessType) {
        LOGGER.debug("search key for " + documentDirectory);
        KeyStoreAccess keyStoreAccess = this.getKeyStoreAccess(userIDAuth);
        DocumentKeyID documentKeyID = this.loadCachedDocumentKeyIDForDocumentDirectory(documentDirectory);
        if (documentKeyID == null) {
            documentKeyID = GuardUtil.tryToLoadBucketGuardKeyFile(this.bucketService, keyStoreAccess.getKeyStorePath().getBucketDirectory(), documentDirectory);
        }
        if (documentKeyID == null) {
            documentKeyID = this.createSymmetricGuardForBucket(keyStoreAccess, documentDirectory, accessType);
        }
        this.cacheDocumentKeyIDForDocumentDirectory(documentDirectory, documentKeyID);
        DocumentKeyIDWithKeyAndAccessType documentKeyIDWithKeyAndAccessType = this.loadCachedOrRealDocumentKeyIDWithKeyAndAccessTypeFromDocumentGuard(keyStoreAccess, documentKeyID);
        LOGGER.debug("found " + documentKeyIDWithKeyAndAccessType + " for " + documentDirectory);
        return documentKeyIDWithKeyAndAccessType;
    }

    private DocumentKeyIDWithKeyAndAccessType getDocumentKeyIDwithKeyForBucketPath(UserIDAuth userIDAuth, BucketDirectory documentDirectory) {
        LOGGER.debug("get key for " + documentDirectory);
        KeyStoreAccess keyStoreAccess = this.getKeyStoreAccess(userIDAuth);
        DocumentKeyID documentKeyID = GuardUtil.loadBucketGuardKeyFile(this.bucketService, keyStoreAccess.getKeyStorePath().getBucketDirectory(), documentDirectory);
        DocumentKeyIDWithKeyAndAccessType documentKeyIDWithKeyAndAccessType = this.loadCachedOrRealDocumentKeyIDWithKeyAndAccessTypeFromDocumentGuard(keyStoreAccess, documentKeyID);
        LOGGER.debug("found " + documentKeyIDWithKeyAndAccessType + " for " + documentDirectory);
        return documentKeyIDWithKeyAndAccessType;
    }

    private void checkUserKeyPassword(UserIDAuth userIDAuth) {
        block7: {
            UserAuthCache userAuthCache;
            UserAuthCache userAuthCache2 = userAuthCache = this.docusafeCacheWrapper != null ? this.docusafeCacheWrapper.getUserAuthCache() : null;
            if (userAuthCache != null) {
                LOGGER.debug("MemoryContext is used");
                ReadKeyPassword expectedFromCache = (ReadKeyPassword)userAuthCache.get(userIDAuth.getUserID());
                if (expectedFromCache != null) {
                    if (expectedFromCache.equals((Object)userIDAuth.getReadKeyPassword())) {
                        LOGGER.debug("MemoryContext successful for " + (Object)((Object)userIDAuth.getUserID()));
                        return;
                    }
                    userAuthCache.remove(userIDAuth.getUserID());
                }
            }
            KeyStoreAccess keyStoreAccess = this.getKeyStoreAccess(userIDAuth);
            BucketDirectory documentDirectory = UserIDUtil.getHomeBucketDirectory(userIDAuth.getUserID());
            DocumentKeyID documentKeyID = GuardUtil.tryToLoadBucketGuardKeyFile(this.bucketService, keyStoreAccess.getKeyStorePath().getBucketDirectory(), documentDirectory);
            if (documentKeyID == null) {
                throw new UserIDDoesNotExistException(userIDAuth.getUserID());
            }
            try {
                this.loadCachedOrRealDocumentKeyIDWithKeyAndAccessTypeFromDocumentGuard(keyStoreAccess, documentKeyID);
                if (userAuthCache != null) {
                    userAuthCache.put(userIDAuth.getUserID(), userIDAuth.getReadKeyPassword());
                }
            }
            catch (BaseException e) {
                if (!(e.getCause() instanceof UnrecoverableEntryException)) break block7;
                throw new WrongPasswordException(userIDAuth.getUserID());
            }
        }
    }

    private DocumentKeyIDWithKeyAndAccessType loadCachedOrRealDocumentKeyIDWithKeyAndAccessTypeFromDocumentGuard(KeyStoreAccess keyStoreAccess, DocumentKeyID documentKeyID) {
        DocumentGuardCache documentGuardCache;
        DocumentKeyIDWithKeyAndAccessType fromCache = this.get(keyStoreAccess, documentKeyID);
        if (fromCache != null) {
            return fromCache;
        }
        DocumentKeyIDWithKeyAndAccessType documentKeyIDWithKeyAndAccessType = this.documentGuardService.loadDocumentKeyIDWithKeyAndAccessTypeFromDocumentGuard(keyStoreAccess, documentKeyID);
        DocumentGuardCache documentGuardCache2 = documentGuardCache = this.docusafeCacheWrapper != null ? this.docusafeCacheWrapper.getDocumentGuardCache() : null;
        if (documentGuardCache != null) {
            String cacheKey = DocumentGuardCache.cacheKeyToString(keyStoreAccess, documentKeyID);
            documentGuardCache.put(cacheKey, new PasswordAndDocumentKeyIDWithKeyAndAccessType(keyStoreAccess.getKeyStoreAuth().getReadKeyPassword(), documentKeyIDWithKeyAndAccessType));
            LOGGER.debug("AAA insert document key for cache key " + cacheKey);
        }
        return documentKeyIDWithKeyAndAccessType;
    }

    void createCachedDocumentGuardFor(GuardKeyType guardKeyType, KeyStoreAccess keyStoreAccess, DocumentKeyIDWithKeyAndAccessType documentKeyIDWithKeyAndAccessType, OverwriteFlag overwriteFlag) {
        DocumentGuardCache documentGuardCache;
        this.documentGuardService.createDocumentGuardFor(guardKeyType, keyStoreAccess, documentKeyIDWithKeyAndAccessType, overwriteFlag);
        DocumentGuardCache documentGuardCache2 = documentGuardCache = this.docusafeCacheWrapper != null ? this.docusafeCacheWrapper.getDocumentGuardCache() : null;
        if (documentGuardCache != null) {
            String cacheKey = DocumentGuardCache.cacheKeyToString(keyStoreAccess, documentKeyIDWithKeyAndAccessType.getDocumentKeyIDWithKey().getDocumentKeyID());
            if (guardKeyType.equals((Object)GuardKeyType.PUBLIC_KEY)) {
                this.deleteCacheKey(keyStoreAccess, documentKeyIDWithKeyAndAccessType.getDocumentKeyIDWithKey().getDocumentKeyID());
            } else {
                documentGuardCache.put(cacheKey, new PasswordAndDocumentKeyIDWithKeyAndAccessType(keyStoreAccess.getKeyStoreAuth().getReadKeyPassword(), documentKeyIDWithKeyAndAccessType));
            }
        }
    }

    private void deleteCacheKey(KeyStoreAccess keyStoreAccess, DocumentKeyID documentKeyID) {
        DocumentGuardCache documentGuardCache;
        DocumentGuardCache documentGuardCache2 = documentGuardCache = this.docusafeCacheWrapper != null ? this.docusafeCacheWrapper.getDocumentGuardCache() : null;
        if (documentGuardCache != null) {
            String cacheKey = DocumentGuardCache.cacheKeyToString(keyStoreAccess, documentKeyID);
            documentGuardCache.remove(cacheKey);
        }
    }

    private DocumentKeyID loadCachedDocumentKeyIDForDocumentDirectory(BucketDirectory bucketDirectory) {
        DocumentKeyIDCache documentKeyIDCache;
        DocumentKeyIDCache documentKeyIDCache2 = documentKeyIDCache = this.docusafeCacheWrapper != null ? this.docusafeCacheWrapper.getDocumentKeyIDCache() : null;
        if (documentKeyIDCache != null) {
            return (DocumentKeyID)documentKeyIDCache.get(bucketDirectory);
        }
        return null;
    }

    private void cacheDocumentKeyIDForDocumentDirectory(BucketDirectory bucketDirectory, DocumentKeyID documentKeyID) {
        DocumentKeyIDCache documentKeyIDCache;
        DocumentKeyIDCache documentKeyIDCache2 = documentKeyIDCache = this.docusafeCacheWrapper != null ? this.docusafeCacheWrapper.getDocumentKeyIDCache() : null;
        if (documentKeyIDCache == null) {
            return;
        }
        documentKeyIDCache.put(bucketDirectory, documentKeyID);
    }

    public DocumentKeyIDWithKeyAndAccessType get(KeyStoreAccess keyStoreAccess, DocumentKeyID documentKeyID) {
        String cacheKey;
        PasswordAndDocumentKeyIDWithKeyAndAccessType passwordAndDocumentKeyIDWithKeyAndAccessTypeFromCache;
        DocumentGuardCache documentGuardCache;
        DocumentGuardCache documentGuardCache2 = documentGuardCache = this.docusafeCacheWrapper != null ? this.docusafeCacheWrapper.getDocumentGuardCache() : null;
        if (documentGuardCache != null && (passwordAndDocumentKeyIDWithKeyAndAccessTypeFromCache = (PasswordAndDocumentKeyIDWithKeyAndAccessType)documentGuardCache.get(cacheKey = DocumentGuardCache.cacheKeyToString(keyStoreAccess, documentKeyID))) != null) {
            if (passwordAndDocumentKeyIDWithKeyAndAccessTypeFromCache.getReadKeyPassword().equals((Object)keyStoreAccess.getKeyStoreAuth().getReadKeyPassword())) {
                LOGGER.debug("AAA return document key for cache key " + cacheKey);
                return ((PasswordAndDocumentKeyIDWithKeyAndAccessType)documentGuardCache.get(cacheKey)).getDocumentKeyIDWithKeyAndAccessType();
            }
            documentGuardCache.remove(cacheKey);
        }
        return null;
    }

    public static String showCache(DocumentSafeService instance) {
        if (!(instance instanceof DocumentSafeServiceImpl)) {
            throw new BaseException("Instance of DocuementSafeService is not of DocumentSafeServiceImpl but " + instance.getClass().getName());
        }
        DocumentSafeServiceImpl impl = (DocumentSafeServiceImpl)instance;
        if (impl.docusafeCacheWrapper == null) {
            return "(DocusafeCacheWrapper is null)";
        }
        return impl.docusafeCacheWrapper.toString();
    }
}

