/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.business;

import com.nimbusds.jose.jwk.JWK;
import org.adorsys.docusafe.business.types.UserID;
import org.adorsys.docusafe.business.types.complex.BucketContentFQN;
import org.adorsys.docusafe.business.types.complex.DSDocument;
import org.adorsys.docusafe.business.types.complex.DSDocumentStream;
import org.adorsys.docusafe.business.types.complex.DocumentDirectoryFQN;
import org.adorsys.docusafe.business.types.complex.DocumentFQN;
import org.adorsys.docusafe.business.types.complex.UserIDAuth;
import org.adorsys.docusafe.service.types.AccessType;
import org.adorsys.encobject.types.ListRecursiveFlag;

public interface DocumentSafeService {
    public void createUser(UserIDAuth var1);

    public void destroyUser(UserIDAuth var1);

    public boolean userExists(UserID var1);

    public JWK findPublicEncryptionKey(UserID var1);

    public void storeDocument(UserIDAuth var1, DSDocument var2);

    public DSDocument readDocument(UserIDAuth var1, DocumentFQN var2);

    public void storeDocumentStream(UserIDAuth var1, DSDocumentStream var2);

    public DSDocumentStream readDocumentStream(UserIDAuth var1, DocumentFQN var2);

    public void deleteDocument(UserIDAuth var1, DocumentFQN var2);

    public boolean documentExists(UserIDAuth var1, DocumentFQN var2);

    public void deleteFolder(UserIDAuth var1, DocumentDirectoryFQN var2);

    public BucketContentFQN list(UserIDAuth var1, DocumentDirectoryFQN var2, ListRecursiveFlag var3);

    public void grantAccessToUserForFolder(UserIDAuth var1, UserID var2, DocumentDirectoryFQN var3, AccessType var4);

    public void storeGrantedDocument(UserIDAuth var1, UserID var2, DSDocument var3);

    public DSDocument readGrantedDocument(UserIDAuth var1, UserID var2, DocumentFQN var3);

    public boolean grantedDocumentExists(UserIDAuth var1, UserID var2, DocumentFQN var3);
}

