/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.business.utils;

import org.adorsys.docusafe.business.types.UserID;
import org.adorsys.docusafe.business.types.complex.UserIDAuth;
import org.adorsys.encobject.complextypes.BucketDirectory;
import org.adorsys.encobject.complextypes.BucketPath;
import org.adorsys.encobject.domain.KeyStoreAuth;
import org.adorsys.encobject.domain.ReadStorePassword;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserIDUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserIDUtil.class);

    public static BucketDirectory getUserRootBucketDirectory(UserID userID) {
        return new BucketDirectory("bp-" + userID.getValue().toLowerCase());
    }

    public static BucketPath getKeyStorePath(UserID userID) {
        return UserIDUtil.getKeyStoreDirectory(userID).appendName("KS-" + userID.getValue());
    }

    public static KeyStoreAuth getKeyStoreAuth(UserIDAuth userIDAuth) {
        return new KeyStoreAuth(UserIDUtil.getReadStorePassword(userIDAuth.getUserID()), userIDAuth.getReadKeyPassword());
    }

    public static BucketDirectory getKeyStoreDirectory(UserID userID) {
        return UserIDUtil.getUserRootBucketDirectory(userID).appendDirectory(".keys");
    }

    public static BucketDirectory getHomeBucketDirectory(UserID userID) {
        return UserIDUtil.getUserRootBucketDirectory(userID).appendDirectory("home");
    }

    public static BucketDirectory getGrantBucketDirectory(UserID userID) {
        return UserIDUtil.getUserRootBucketDirectory(userID).appendDirectory(".grants");
    }

    private static ReadStorePassword getReadStorePassword(UserID userID) {
        return new ReadStorePassword("ReadStorePasswordFor" + userID.getValue());
    }
}

